/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.gui.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import red.felnull.imp.client.gui.screen.IMPAbstractMonitorEquipmentScreen;
import red.felnull.imp.client.gui.screen.IMusicPlayListScreen;
import red.felnull.imp.music.resource.PlayList;
import red.felnull.imp.music.resource.PlayMusic;
import red.felnull.imp.tileentity.IMPAbstractPAPLEquipmentTileEntity;
import red.felnull.otyacraftengine.util.ClockTimer;

public abstract class IMPAbstractPLEquipmentScreen<T extends Container>
extends IMPAbstractMonitorEquipmentScreen<T>
implements IMusicPlayListScreen {
    private final List<PlayList> jonedAllPlaylists = new ArrayList<PlayList>();
    private final List<PlayMusic> currentPlayMusics = new ArrayList<PlayMusic>();
    private PlayList currentPlayList = PlayList.ALL;
    private ClockTimer updateTimer;
    public boolean isFristMLUpdate;
    private Sort sorts = Sort.NAME;

    public IMPAbstractPLEquipmentScreen(T screenContainer, PlayerInventory playerInventory, ITextComponent titleIn) {
        super(screenContainer, playerInventory, titleIn);
    }

    @Override
    public void initByIKSG() {
        super.initByIKSG();
        this.updateAll();
        this.timerSet();
    }

    @Override
    public void updatePlayList() {
        this.instruction("PlayListUpdate", new CompoundNBT());
    }

    @Override
    public void updatePlayMusic() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("uuid", this.currentPlayList.getUUID());
        this.instruction("PlayMusicUpdate", tag);
    }

    @Override
    protected void insPower(boolean on) {
        super.insPower(on);
        this.updateAll();
    }

    @Override
    public PlayList getCurrentSelectedPlayList() {
        return this.currentPlayList;
    }

    @Override
    public void setCurrentSelectedPlayList(PlayList list) {
        this.currentPlayList = list;
    }

    @Override
    public List<PlayList> getJonedAllPlayLists() {
        return this.jonedAllPlaylists;
    }

    @Override
    public List<PlayMusic> getCurrentPLPlayMusic() {
        return this.currentPlayMusics;
    }

    private void timerSet() {
        this.updateTimer = new ClockTimer(n -> this.isOpend());
        this.updateTimer.addTask("updateplaylist", new ClockTimer.ITask(){

            public boolean isStop(ClockTimer clockTimer) {
                return false;
            }

            public void run(ClockTimer clockTimer) {
                IMPAbstractPLEquipmentScreen.this.updateAll();
            }

            public long time(ClockTimer clockTimer) {
                return 500L;
            }
        });
    }

    public void insLastPlayList() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("uuid", this.currentPlayList.getUUID());
        this.instruction("LastPlayListSet", tag);
    }

    private String getLastPlayListUUID() {
        String pathst = ((IMPAbstractPAPLEquipmentTileEntity)this.getTileEntity()).getLastPlayList((PlayerEntity)this.getMinecraft().field_71439_g);
        return pathst;
    }

    public void onCloseByIKSG() {
        super.onCloseByIKSG();
        if (this.getCurrentSelectedPlayList() != null) {
            this.insLastPlayList();
        }
    }

    public void removeLastPlayList() {
        this.instruction("LastPlayListSet", new CompoundNBT());
    }

    public void instructionReturn(String name, CompoundNBT tag) {
        if (name.equals("PlayListUpdate")) {
            this.jonedAllPlaylists.clear();
            boolean nonslflg = false;
            for (String pltagst : tag.func_150296_c()) {
                PlayList pl = new PlayList(pltagst, tag.func_74775_l(pltagst));
                this.jonedAllPlaylists.add(pl);
                if (!pl.equals(this.getCurrentSelectedPlayList())) continue;
                nonslflg = true;
                this.setCurrentSelectedPlayList(pl);
            }
            if (!nonslflg) {
                this.setCurrentSelectedPlayList(PlayList.ALL);
            }
            if (!this.isFristMLUpdate) {
                String lastPlayMusic = this.getLastPlayListUUID();
                if (!lastPlayMusic.isEmpty()) {
                    PlayList list = PlayList.ALL;
                    for (PlayList pl : this.jonedAllPlaylists) {
                        if (!pl.getUUID().equals(lastPlayMusic)) continue;
                        list = pl;
                        break;
                    }
                    this.currentPlayList = list;
                    if (this.currentPlayList != PlayList.ALL) {
                        this.updatePlayMusic();
                    }
                } else {
                    this.currentPlayList = PlayList.ALL;
                }
                this.isFristMLUpdate = true;
            }
        } else if (name.equals("PlayMusicUpdate") && this.currentPlayList.getUUID().equals(tag.func_74779_i("uuid"))) {
            CompoundNBT taga = tag.func_74775_l("list");
            this.currentPlayMusics.clear();
            ArrayList<PlayMusic> addMusic = new ArrayList<PlayMusic>();
            for (String pmtagst : taga.func_150296_c()) {
                addMusic.add(new PlayMusic(pmtagst, taga.func_74775_l(pmtagst)));
            }
            this.currentPlayMusics.addAll((Collection)this.sorts.listsf.apply(addMusic));
        }
    }

    public void setSorts(Sort sorts) {
        this.sorts = sorts;
    }

    public static enum Sort {
        NAME(n -> n.stream().sorted(Comparator.comparing(PlayMusic::getName)).collect(Collectors.toList())),
        TIME(n -> n.stream().sorted(Comparator.comparing(PlayMusic::getTimeStamp)).collect(Collectors.toList())),
        LENGTH(n -> n.stream().sorted(Comparator.comparing(PlayMusic::getLengthInMilliseconds)).collect(Collectors.toList())),
        PLAYER(n -> n.stream().sorted(Comparator.comparing(PlayMusic::getCreatePlayerName)).collect(Collectors.toList()));

        private final Function<List<PlayMusic>, List<PlayMusic>> listsf;

        private Sort(Function<List<PlayMusic>, List<PlayMusic>> listsf) {
            this.listsf = listsf;
        }

        public Function<List<PlayMusic>, List<PlayMusic>> getListsf() {
            return this.listsf;
        }
    }
}

