/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.handler;

import java.io.File;
import java.nio.file.Path;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import red.felnull.imp.data.IMPWorldData;
import red.felnull.imp.data.PlayListGuildManeger;
import red.felnull.imp.item.IMPItems;
import red.felnull.imp.music.ServerWorldMusicManager;
import red.felnull.imp.util.PathUtils;
import red.felnull.otyacraftengine.api.ResponseSender;
import red.felnull.otyacraftengine.api.event.common.ReceiverEvent;
import red.felnull.otyacraftengine.api.event.common.ResponseEvent;
import red.felnull.otyacraftengine.data.SendReceiveLogger;
import red.felnull.otyacraftengine.util.IKSGDataUtil;
import red.felnull.otyacraftengine.util.IKSGFileLoadUtil;

public class ServerHandler {
    @SubscribeEvent
    public static void onClientResponse(ResponseEvent.Client e) {
        if (e.getLocation().equals((Object)IMPWorldData.PLAYLIST_REQUEST) && e.getId() == 0) {
            PlayListGuildManeger.instance().joinPlayList(e.getPlayer(), e.getMessage());
        }
    }

    @SubscribeEvent
    public static void onReceiverPos(ReceiverEvent.Server.Pos e) {
        if (e.getLocation().equals((Object)IMPWorldData.SERVER_MUSIC_DATA)) {
            ServerHandler.sendMusicUploadResultState(e.getPlayer(), e.getName(), e.getReceiveResult(), "unziped");
            try {
                byte[] compdata = IKSGFileLoadUtil.fileBytesReader((Path)PathUtils.getWorldTmpFolder().resolve(e.getName()));
                IKSGFileLoadUtil.fileBytesWriter((byte[])IKSGDataUtil.gzUnZipping((byte[])compdata), (Path)PathUtils.getWorldTmpFolder().resolve(e.getName() + "-tmp"));
                IKSGFileLoadUtil.deleteFile((Path)PathUtils.getWorldTmpFolder().resolve(e.getName()));
                File file = PathUtils.getWorldTmpFolder().resolve(e.getName() + "-tmp").toFile();
                IKSGFileLoadUtil.createFolder((Path)PathUtils.getWorldMusicFolder());
                file.renameTo(PathUtils.getWorldMusicFolder().resolve(e.getName()).toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ServerHandler.sendMusicUploadResultState(e.getPlayer(), e.getName(), e.getReceiveResult(), "complete");
        }
    }

    private static void sendMusicUploadResultState(ServerPlayerEntity player, String uuid, SendReceiveLogger.SRResult result, String state) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("result", result.name());
        tag.func_74778_a("state", state);
        ResponseSender.sendToClient((ServerPlayerEntity)player, (ResourceLocation)IMPWorldData.SEND_MUSIC_RESPONSE, (int)0, (String)uuid, (CompoundNBT)tag);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent e) {
        ServerWorldMusicManager.instance().tick();
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent e) {
        ServerWorldMusicManager.instance().clear();
    }

    @SubscribeEvent
    public static void onServerStopping(FMLServerStoppingEvent e) {
        ServerWorldMusicManager.instance().clear();
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent e) {
        if (e.getName().toString().equals("minecraft:chests/simple_dungeon")) {
            LootPool pool = LootPool.func_216096_a().func_216046_a((IRandomRange)new RandomValueRange(1.0f)).func_212840_b_(RandomChance.func_216004_a((float)0.081f)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)IMPItems.IKISUGI_ANTENNA).func_216086_a(1)).name(new ResourceLocation("iammusicplayer", "antenna").toString()).func_216044_b();
            e.getTable().addPool(pool);
        }
    }
}

