/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.com.github.kiulian.downloader;

import java.util.List;
import red.felnull.imp.libs.com.alibaba.fastjson.JSONObject;
import red.felnull.imp.libs.com.github.kiulian.downloader.YoutubeException;
import red.felnull.imp.libs.com.github.kiulian.downloader.cipher.CipherFunction;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.VideoDetails;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.YoutubeVideo;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.formats.Format;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.playlist.PlaylistDetails;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.playlist.PlaylistVideoDetails;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.playlist.YoutubePlaylist;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import red.felnull.imp.libs.com.github.kiulian.downloader.parser.DefaultParser;
import red.felnull.imp.libs.com.github.kiulian.downloader.parser.Parser;

public class YoutubeDownloader {
    private Parser parser;

    public YoutubeDownloader() {
        this.parser = new DefaultParser();
    }

    public YoutubeDownloader(Parser parser) {
        this.parser = parser;
    }

    public void setParserRequestProperty(String key, String value) {
        this.parser.getExtractor().setRequestProperty(key, value);
    }

    public void setParserRetryOnFailure(int retryOnFailure) {
        this.parser.getExtractor().setRetryOnFailure(retryOnFailure);
    }

    public void addCipherFunctionPattern(int priority, String regex) {
        this.parser.getCipherFactory().addInitialFunctionPattern(priority, regex);
    }

    public void addCipherFunctionEquivalent(String regex, CipherFunction function) {
        this.parser.getCipherFactory().addFunctionEquivalent(regex, function);
    }

    public YoutubeVideo getVideo(String videoId) throws YoutubeException {
        String htmlUrl = "https://www.youtube.com/watch?v=" + videoId;
        JSONObject ytPlayerConfig = this.parser.getPlayerConfig(htmlUrl);
        ytPlayerConfig.put("yt-downloader-videoId", (Object)videoId);
        VideoDetails videoDetails = this.parser.getVideoDetails(ytPlayerConfig);
        List<Format> formats = this.parser.parseFormats(ytPlayerConfig);
        List<SubtitlesInfo> subtitlesInfo = this.parser.getSubtitlesInfoFromCaptions(ytPlayerConfig);
        String clientVersion = this.parser.getClientVersion(ytPlayerConfig);
        return new YoutubeVideo(videoDetails, formats, subtitlesInfo, clientVersion);
    }

    public YoutubePlaylist getPlaylist(String playlistId) throws YoutubeException {
        String htmlUrl = "https://www.youtube.com/playlist?list=" + playlistId;
        JSONObject ytInitialData = this.parser.getInitialData(htmlUrl);
        PlaylistDetails playlistDetails = this.parser.getPlaylistDetails(playlistId, ytInitialData);
        List<PlaylistVideoDetails> videos = this.parser.getPlaylistVideos(ytInitialData, playlistDetails.videoCount());
        return new YoutubePlaylist(playlistDetails, videos);
    }

    public List<SubtitlesInfo> getVideoSubtitles(String videoId) throws YoutubeException {
        return this.parser.getSubtitlesInfo(videoId);
    }
}

