/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.com.github.kiulian.downloader.model;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.formats.Format;

public class Utils {
    private static final char[] ILLEGAL_FILENAME_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};

    private static String removeIllegalChars(String fileName) {
        for (char c : ILLEGAL_FILENAME_CHARACTERS) {
            fileName = fileName.replace(c, '_');
        }
        return fileName;
    }

    static void createOutDir(File outDir) throws IOException {
        boolean mkdirs;
        if (!outDir.exists() && !(mkdirs = outDir.mkdirs())) {
            throw new IOException("Could not create output directory: " + outDir);
        }
    }

    static File getOutputFile(String name, Format format, File outDir, boolean overwrite) {
        String fileName = Utils.removeIllegalChars(name) + "." + format.extension().value();
        File outputFile = new File(outDir, fileName);
        if (!overwrite) {
            int i = 1;
            while (outputFile.exists()) {
                fileName = Utils.removeIllegalChars(name) + "(" + i++ + ")." + format.extension().value();
                outputFile = new File(outDir, fileName);
            }
        }
        return outputFile;
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

