/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.com.github.kiulian.downloader.model;

import java.util.ArrayList;
import java.util.List;
import red.felnull.imp.libs.com.alibaba.fastjson.JSONObject;
import red.felnull.imp.libs.com.github.kiulian.downloader.YoutubeException;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.AbstractVideoDetails;

public class VideoDetails
extends AbstractVideoDetails {
    private List<String> keywords;
    private String shortDescription;
    private long viewCount;
    private int averageRating;
    private boolean isLiveContent;
    private String liveUrl;

    public VideoDetails() {
    }

    public VideoDetails(JSONObject json, String liveHLSUrl) {
        super(json);
        this.title = json.getString("title");
        this.author = json.getString("author");
        this.isLive = json.getBooleanValue("isLive");
        this.keywords = json.containsKey("keywords") ? json.getJSONArray("keywords").toJavaList(String.class) : new ArrayList<String>();
        this.shortDescription = json.getString("shortDescription");
        this.averageRating = json.getIntValue("averageRating");
        this.viewCount = json.getLongValue("viewCount");
        this.isLiveContent = json.getBooleanValue("isLiveContent");
        this.liveUrl = liveHLSUrl;
    }

    @Override
    protected void checkDownload() throws YoutubeException.LiveVideoException {
        if (this.isLive || this.isLiveContent && this.lengthSeconds() == 0) {
            throw new YoutubeException.LiveVideoException("Can not download live stream");
        }
    }

    public List<String> keywords() {
        return this.keywords;
    }

    public String description() {
        return this.shortDescription;
    }

    public long viewCount() {
        return this.viewCount;
    }

    public int averageRating() {
        return this.averageRating;
    }

    public boolean isLiveContent() {
        return this.isLiveContent;
    }

    public String liveUrl() {
        return this.liveUrl;
    }
}

