/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.com.github.kiulian.downloader.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import red.felnull.imp.libs.com.github.kiulian.downloader.OnYoutubeDownloadListener;
import red.felnull.imp.libs.com.github.kiulian.downloader.YoutubeException;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.Extension;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.Filter;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.Utils;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.VideoDetails;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.formats.AudioFormat;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.formats.AudioVideoFormat;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.formats.Format;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.formats.VideoFormat;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.quality.AudioQuality;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.quality.VideoQuality;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;

public class YoutubeVideo {
    private static final int BUFFER_SIZE = 4096;
    private static final int PART_LENGTH = 0x200000;
    private VideoDetails videoDetails;
    private List<Format> formats;
    private List<SubtitlesInfo> subtitlesInfo;
    private final String clientVersion;

    public YoutubeVideo(VideoDetails videoDetails, List<Format> formats, List<SubtitlesInfo> subtitlesInfo, String clientVersion) {
        this.videoDetails = videoDetails;
        this.formats = formats;
        this.subtitlesInfo = subtitlesInfo;
        this.clientVersion = clientVersion;
    }

    public VideoDetails details() {
        return this.videoDetails;
    }

    public List<Format> formats() {
        return this.formats;
    }

    public List<SubtitlesInfo> subtitles() {
        return this.subtitlesInfo;
    }

    public List<Format> findFormats(Filter<Format> filter) {
        return filter.select(this.formats);
    }

    public Format findFormatByItag(int itag) {
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (format.itag().id() != itag) continue;
            return format;
        }
        return null;
    }

    public List<AudioVideoFormat> videoWithAudioFormats() {
        LinkedList<AudioVideoFormat> find = new LinkedList<AudioVideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioVideoFormat)) continue;
            find.add((AudioVideoFormat)format);
        }
        return find;
    }

    public List<VideoFormat> videoFormats() {
        LinkedList<VideoFormat> find = new LinkedList<VideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof VideoFormat)) continue;
            find.add((VideoFormat)format);
        }
        return find;
    }

    public List<VideoFormat> findVideoWithQuality(VideoQuality videoQuality) {
        LinkedList<VideoFormat> find = new LinkedList<VideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof VideoFormat) || ((VideoFormat)format).videoQuality() != videoQuality) continue;
            find.add((VideoFormat)format);
        }
        return find;
    }

    public List<VideoFormat> findVideoWithExtension(Extension extension) {
        LinkedList<VideoFormat> find = new LinkedList<VideoFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof VideoFormat) || !format.extension().equals(extension)) continue;
            find.add((VideoFormat)format);
        }
        return find;
    }

    public List<AudioFormat> audioFormats() {
        LinkedList<AudioFormat> find = new LinkedList<AudioFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioFormat)) continue;
            find.add((AudioFormat)format);
        }
        return find;
    }

    public List<AudioFormat> findAudioWithQuality(AudioQuality audioQuality) {
        LinkedList<AudioFormat> find = new LinkedList<AudioFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioFormat) || ((AudioFormat)format).audioQuality() != audioQuality) continue;
            find.add((AudioFormat)format);
        }
        return find;
    }

    public List<AudioFormat> findAudioWithExtension(Extension extension) {
        LinkedList<AudioFormat> find = new LinkedList<AudioFormat>();
        for (int i = 0; i < this.formats.size(); ++i) {
            Format format = this.formats.get(i);
            if (!(format instanceof AudioFormat) || format.extension() != extension) continue;
            find.add((AudioFormat)format);
        }
        return find;
    }

    public File download(Format format, File outDir) throws IOException, YoutubeException {
        return this.download(format, outDir, this.videoDetails.title());
    }

    public File download(Format format, File outDir, String fileName) throws IOException, YoutubeException {
        return this.download(format, outDir, fileName, false);
    }

    public File download(Format format, File outDir, String fileName, boolean overwrite) throws IOException, YoutubeException {
        File outputFile = this.initDownload(format, outDir, fileName, overwrite);
        return this.basicDownload(format, outputFile, null);
    }

    public Future<File> downloadAsync(Format format, File outDir) throws YoutubeException.LiveVideoException, IOException {
        return this.downloadAsync(format, outDir, this.videoDetails.title());
    }

    public Future<File> downloadAsync(Format format, File outDir, String fileName) throws YoutubeException.LiveVideoException, IOException {
        return this.downloadAsync(format, outDir, fileName, false, null);
    }

    public Future<File> downloadAsync(Format format, File outDir, OnYoutubeDownloadListener listener) throws IOException, YoutubeException {
        return this.downloadAsync(format, outDir, this.videoDetails.title(), listener);
    }

    public Future<File> downloadAsync(Format format, File outDir, String fileName, OnYoutubeDownloadListener listener) throws IOException, YoutubeException {
        return this.downloadAsync(format, outDir, fileName, false, listener);
    }

    public Future<File> downloadAsync(Format format, File outDir, String fileName, boolean overwrite, OnYoutubeDownloadListener listener) throws YoutubeException.LiveVideoException, IOException {
        File outputFile = this.initDownload(format, outDir, fileName, overwrite);
        FutureTask<File> future = new FutureTask<File>(() -> this.basicDownload(format, outputFile, listener));
        Thread thread = new Thread(future, "YtDownloader");
        thread.setDaemon(true);
        thread.start();
        return future;
    }

    private File initDownload(Format format, File outDir, String fileName, boolean overwrite) throws IOException, YoutubeException.LiveVideoException {
        this.videoDetails.checkDownload();
        Utils.createOutDir(outDir);
        return Utils.getOutputFile(fileName, format, outDir, overwrite);
    }

    private File basicDownload(Format format, File outputFile, OnYoutubeDownloadListener listener) throws IOException {
        FileOutputStream os;
        boolean exception;
        block9: {
            exception = false;
            os = null;
            try {
                os = new FileOutputStream(outputFile);
                if (format.isAdaptive() && format.contentLength() != null) {
                    this.downloadByPart(format, os, listener);
                } else {
                    this.downloadStraight(format, os, listener);
                }
                if (listener == null) break block9;
                listener.onFinished(outputFile);
            }
            catch (IOException | CancellationException e) {
                try {
                    exception = true;
                    if (listener != null) {
                        listener.onError(e);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    Utils.closeSilently(os);
                    if (exception) {
                        outputFile.delete();
                    }
                    throw throwable;
                }
            }
        }
        Utils.closeSilently(os);
        if (exception) {
            outputFile.delete();
        }
        return outputFile;
    }

    private void downloadStraight(Format format, OutputStream os, OnYoutubeDownloadListener listener) throws IOException {
        URLConnection urlConnection = new URL(format.url()).openConnection();
        int contentLength = urlConnection.getContentLength();
        InputStream is = urlConnection.getInputStream();
        byte[] buffer = new byte[4096];
        if (listener == null) {
            YoutubeVideo.copyAndCloseInput(is, os, buffer);
        } else {
            YoutubeVideo.copyAndCloseInput(is, os, buffer, 0L, contentLength, listener);
        }
    }

    private void downloadByPart(Format format, OutputStream os, OnYoutubeDownloadListener listener) throws IOException {
        long done = 0L;
        int partNumber = 0;
        String pathPrefix = "&cver=" + this.clientVersion + "&range=";
        long contentLength = format.contentLength();
        byte[] buffer = new byte[4096];
        while (done < contentLength) {
            long toRead = 0x200000L;
            if (done + toRead > contentLength) {
                toRead = (int)(contentLength - done);
            }
            String partUrl = format.url() + pathPrefix + done + "-" + (done + toRead - 1L) + "&rn=" + ++partNumber;
            URL url = new URL(partUrl);
            InputStream is = url.openStream();
            if (listener == null) {
                done += YoutubeVideo.copyAndCloseInput(is, os, buffer);
                continue;
            }
            done += YoutubeVideo.copyAndCloseInput(is, os, buffer, done, contentLength, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyAndCloseInput(InputStream is, OutputStream os, byte[] buffer, long offset, long totalLength, OnYoutubeDownloadListener listener) throws IOException {
        long done = 0L;
        try {
            long lastProgress;
            int read = 0;
            long l = lastProgress = offset == 0L ? 0L : offset * 100L / totalLength;
            while ((read = is.read(buffer)) != -1) {
                if (Thread.interrupted()) {
                    throw new CancellationException("Downloading is canceled");
                }
                os.write(buffer, 0, read);
                long progress = (offset + (done += (long)read)) * 100L / totalLength;
                if (progress <= lastProgress) continue;
                listener.onDownloading((int)progress);
                lastProgress = progress;
            }
        }
        finally {
            Utils.closeSilently(is);
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyAndCloseInput(InputStream is, OutputStream os, byte[] buffer) throws IOException {
        long done = 0L;
        try {
            int count = 0;
            while ((count = is.read(buffer)) != -1) {
                if (Thread.interrupted()) {
                    throw new CancellationException("Downloading is canceled");
                }
                os.write(buffer, 0, count);
                done += (long)count;
            }
        }
        finally {
            Utils.closeSilently(is);
        }
        return done;
    }
}

