/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.com.github.kiulian.downloader.model.formats;

import red.felnull.imp.libs.com.alibaba.fastjson.JSONObject;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.Extension;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.Itag;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.formats.AudioFormat;

public abstract class Format {
    public static final String AUDIO = "audio";
    public static final String VIDEO = "video";
    public static final String AUDIO_VIDEO = "audio/video";
    private final boolean isAdaptive;
    protected final Itag itag;
    protected final String url;
    protected final String mimeType;
    protected final Extension extension;
    protected final Integer bitrate;
    protected final Long contentLength;
    protected final Long lastModified;
    protected final Long approxDurationMs;

    protected Format(JSONObject json, boolean isAdaptive) {
        Itag itag;
        this.isAdaptive = isAdaptive;
        try {
            itag = Itag.valueOf("i" + json.getInteger("itag"));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            itag = Itag.unknown;
            itag.setId(json.getIntValue("itag"));
        }
        this.itag = itag;
        this.url = json.getString("url").replace("\\u0026", "&");
        this.mimeType = json.getString("mimeType");
        this.bitrate = json.getInteger("bitrate");
        this.contentLength = json.getLong("contentLength");
        this.lastModified = json.getLong("lastModified");
        this.approxDurationMs = json.getLong("approxDurationMs");
        this.extension = this.mimeType == null || this.mimeType.isEmpty() ? Extension.UNKNOWN : (this.mimeType.contains(Extension.MPEG4.value()) ? (this instanceof AudioFormat ? Extension.M4A : Extension.MPEG4) : (this.mimeType.contains(Extension.WEBM.value()) ? (this instanceof AudioFormat ? Extension.WEBA : Extension.WEBM) : (this.mimeType.contains(Extension.FLV.value()) ? Extension.FLV : (this.mimeType.contains(Extension._3GP.value()) ? Extension._3GP : Extension.UNKNOWN))));
    }

    public abstract String type();

    public boolean isAdaptive() {
        return this.isAdaptive;
    }

    public Itag itag() {
        return this.itag;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public String url() {
        return this.url;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public Long duration() {
        return this.approxDurationMs;
    }

    public Extension extension() {
        return this.extension;
    }
}

