/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.com.sedmelluq.lava.common.natives;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.function.Predicate;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.NativeLibraryBinaryProvider;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.NativeLibraryProperties;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.ResourceNativeLibraryBinaryProvider;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.SystemNativeLibraryProperties;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.architecture.SystemType;
import red.felnull.imp.libs.org.apache.commons.io.IOUtils;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class NativeLibraryLoader {
    private static final Logger log = LoggerFactory.getLogger(NativeLibraryLoader.class);
    private static final String DEFAULT_PROPERTY_PREFIX = "lava.native.";
    private static final String DEFAULT_RESOURCE_ROOT = "/red/felnull/imp/libs/natives/";
    private final String libraryName;
    private final Predicate<SystemType> systemFilter;
    private final NativeLibraryProperties properties;
    private final NativeLibraryBinaryProvider binaryProvider;
    private final Object lock;
    private volatile LoadResult previousResult;

    public NativeLibraryLoader(String libraryName, Predicate<SystemType> systemFilter, NativeLibraryProperties properties, NativeLibraryBinaryProvider binaryProvider) {
        this.libraryName = libraryName;
        this.systemFilter = systemFilter;
        this.binaryProvider = binaryProvider;
        this.properties = properties;
        this.lock = new Object();
    }

    public static NativeLibraryLoader create(Class<?> classLoaderSample, String libraryName) {
        return NativeLibraryLoader.createFiltered(classLoaderSample, libraryName, null);
    }

    public static NativeLibraryLoader createFiltered(Class<?> classLoaderSample, String libraryName, Predicate<SystemType> systemFilter) {
        return new NativeLibraryLoader(libraryName, systemFilter, new SystemNativeLibraryProperties(libraryName, DEFAULT_PROPERTY_PREFIX), new ResourceNativeLibraryBinaryProvider(classLoaderSample, DEFAULT_RESOURCE_ROOT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        LoadResult result = this.previousResult;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.previousResult;
                if (result == null) {
                    this.previousResult = result = this.loadWithFailureCheck();
                }
            }
        }
        if (!result.success) {
            throw result.exception;
        }
    }

    private LoadResult loadWithFailureCheck() {
        log.info("Native library {}: loading with filter {}", (Object)this.libraryName, (Object)this.systemFilter);
        try {
            this.loadInternal();
            return new LoadResult(true, null);
        }
        catch (Throwable e) {
            log.error("Native library {}: loading failed.", (Object)this.libraryName, (Object)e);
            return new LoadResult(false, new RuntimeException(e));
        }
    }

    private void loadInternal() {
        String explicitPath = this.properties.getLibraryPath();
        if (explicitPath != null) {
            log.debug("Native library {}: explicit path provided {}", (Object)this.libraryName, (Object)explicitPath);
            this.loadFromFile(Paths.get(explicitPath, new String[0]).toAbsolutePath());
        } else {
            SystemType systemType = this.detectMatchingSystemType();
            if (systemType != null) {
                String explicitDirectory = this.properties.getLibraryDirectory();
                if (explicitDirectory != null) {
                    log.debug("Native library {}: explicit directory provided {}", (Object)this.libraryName, (Object)explicitDirectory);
                    this.loadFromFile(Paths.get(explicitDirectory, systemType.formatLibraryName(this.libraryName)).toAbsolutePath());
                } else {
                    this.loadFromFile(this.extractLibraryFromResources(systemType));
                }
            }
        }
    }

    private void loadFromFile(Path libraryFilePath) {
        log.debug("Native library {}: attempting to load library at {}", (Object)this.libraryName, (Object)libraryFilePath);
        System.load(libraryFilePath.toAbsolutePath().toString());
        log.info("Native library {}: successfully loaded.", (Object)this.libraryName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path extractLibraryFromResources(SystemType systemType) {
        try (InputStream libraryStream = this.binaryProvider.getLibraryStream(systemType, this.libraryName);){
            if (libraryStream == null) {
                throw new UnsatisfiedLinkError("Required library was not found");
            }
            Path extractedLibraryPath = this.prepareExtractionDirectory().resolve(systemType.formatLibraryName(this.libraryName));
            try (FileOutputStream fileStream = new FileOutputStream(extractedLibraryPath.toFile());){
                IOUtils.copy(libraryStream, (OutputStream)fileStream);
            }
            Path path = extractedLibraryPath;
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Path prepareExtractionDirectory() throws IOException {
        Path extractionDirectory = this.detectExtractionBaseDirectory().resolve(String.valueOf(System.currentTimeMillis()));
        if (!Files.isDirectory(extractionDirectory, new LinkOption[0])) {
            log.debug("Native library {}: extraction directory {} does not exist, creating.", (Object)this.libraryName, (Object)extractionDirectory);
            try {
                NativeLibraryLoader.createDirectoriesWithFullPermissions(extractionDirectory);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new IOException("Failed to create directory for unpacked native library.", e);
            }
        } else {
            log.debug("Native library {}: extraction directory {} already exists, using.", (Object)this.libraryName, (Object)extractionDirectory);
        }
        return extractionDirectory;
    }

    private Path detectExtractionBaseDirectory() {
        String explicitExtractionBase = this.properties.getExtractionPath();
        if (explicitExtractionBase != null) {
            log.debug("Native library {}: explicit extraction path provided - {}", (Object)this.libraryName, (Object)explicitExtractionBase);
            return Paths.get(explicitExtractionBase, new String[0]).toAbsolutePath();
        }
        Path path = Paths.get(System.getProperty("java.io.tmpdir", "/tmp"), "lava-jni-natives").toAbsolutePath();
        log.debug("Native library {}: detected {} as base directory for extraction.", (Object)this.libraryName, (Object)path);
        return path;
    }

    private SystemType detectMatchingSystemType() {
        SystemType systemType;
        try {
            systemType = SystemType.detect(this.properties);
        }
        catch (IllegalArgumentException e) {
            if (this.systemFilter != null) {
                log.info("Native library {}: could not detect sytem type, but system filter is {} - assuming it does not match and skipping library.", (Object)this.libraryName, (Object)this.systemFilter);
                return null;
            }
            throw e;
        }
        if (this.systemFilter != null && !this.systemFilter.test(systemType)) {
            log.debug("Native library {}: system filter does not match detected system {}, skipping", (Object)this.libraryName, (Object)systemType.formatSystemName());
            return null;
        }
        return systemType;
    }

    private static void createDirectoriesWithFullPermissions(Path path) throws IOException {
        boolean isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        if (!isPosix) {
            Files.createDirectories(path, new FileAttribute[0]);
        } else {
            Files.createDirectories(path, PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx")));
        }
    }

    private static class LoadResult {
        public final boolean success;
        public final RuntimeException exception;

        private LoadResult(boolean success, RuntimeException exception) {
            this.success = success;
            this.exception = exception;
        }
    }
}

