/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.org.apache.http.protocol;

import java.io.IOException;
import red.felnull.imp.libs.org.apache.http.HttpEntityEnclosingRequest;
import red.felnull.imp.libs.org.apache.http.HttpException;
import red.felnull.imp.libs.org.apache.http.HttpRequest;
import red.felnull.imp.libs.org.apache.http.HttpRequestInterceptor;
import red.felnull.imp.libs.org.apache.http.annotation.Contract;
import red.felnull.imp.libs.org.apache.http.annotation.ThreadingBehavior;
import red.felnull.imp.libs.org.apache.http.protocol.HttpContext;
import red.felnull.imp.libs.org.apache.http.protocol.HttpDateGenerator;
import red.felnull.imp.libs.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

