/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.music;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import red.felnull.imp.music.IWorldRingWhether;
import red.felnull.imp.music.WorldMusicRinger;
import red.felnull.imp.music.resource.PlayMusic;
import red.felnull.otyacraftengine.util.IKSGPlayerUtil;

public class ServerWorldMusicManager {
    private static ServerWorldMusicManager INSTANCE;
    private Map<UUID, WorldMusicRinger> ringdMusics = new HashMap<UUID, WorldMusicRinger>();

    public static void init() {
        INSTANCE = new ServerWorldMusicManager();
    }

    public static ServerWorldMusicManager instance() {
        return INSTANCE;
    }

    public void play(UUID uuid, ResourceLocation dimention, PlayMusic music, IWorldRingWhether whether) {
        WorldMusicRinger wrp = new WorldMusicRinger(uuid, dimention, music, whether);
        this.ringdMusics.put(uuid, wrp);
        wrp.play();
    }

    public boolean isPlaying(UUID uuid) {
        return this.ringdMusics.containsKey(uuid);
    }

    public boolean isWaiting(UUID uuid) {
        return this.ringdMusics.containsKey(uuid) && this.ringdMusics.get(uuid).isPlayWaiting();
    }

    public void stop(UUID uuid) {
        if (this.ringdMusics.containsKey(uuid)) {
            this.ringdMusics.get(uuid).pause();
        }
        this.ringdMusics.remove(uuid);
    }

    public void clear() {
        ArrayList<UUID> removeRingers = new ArrayList<UUID>(this.ringdMusics.keySet());
        removeRingers.forEach(this::stop);
    }

    public void tick() {
        List<UUID> removeRingers = this.ringdMusics.entrySet().stream().filter(n -> ((WorldMusicRinger)n.getValue()).tick()).map(Map.Entry::getKey).collect(Collectors.toList());
        removeRingers.forEach(this::stop);
    }

    public void loadingNotFinishRegularConfirmation(UUID uuid, ServerPlayerEntity player) {
        if (this.ringdMusics.containsKey(uuid)) {
            this.ringdMusics.get(uuid).musicLoadingNotFinishRegularConfirmation(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)player)));
        }
    }

    public void loadingFinish(UUID uuid, ServerPlayerEntity player) {
        if (this.ringdMusics.containsKey(uuid)) {
            this.ringdMusics.get(uuid).musicLoadingFinish(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)player)));
        }
    }
}

