/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.music.resource;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import red.felnull.imp.IamMusicPlayer;
import red.felnull.imp.data.IMPWorldData;
import red.felnull.imp.music.resource.PlayImage;
import red.felnull.imp.music.resource.PlayMusic;
import red.felnull.otyacraftengine.data.INBTReadWriter;
import red.felnull.otyacraftengine.data.WorldDataManager;
import red.felnull.otyacraftengine.util.IKSGNBTUtil;
import red.felnull.otyacraftengine.util.IKSGPlayerUtil;

public class PlayList
implements INBTReadWriter {
    public static final PlayList EMPTY = new PlayList("3b88748c-a1a4-4819-aa75-0e175682c47b", "empty", PlayImage.EMPTY, "", "", "", false, new ArrayList<String>());
    public static final PlayList ALL = new PlayList("6681f205-ea7c-4fee-9149-fbe8226143c6", "all", new PlayImage(PlayImage.ImageType.STRING, "all"), "", "", "", false, new ArrayList<String>());
    private final String UUID;
    private String name;
    private String createPlayerName;
    private String createPlayerUUID;
    private String timeStamp;
    private boolean Anyone;
    private PlayImage image;
    private List<String> ownerPlayerUUIDs;

    public PlayList(String UUID2, CompoundNBT tag) {
        this.UUID = UUID2;
        this.read(tag);
    }

    public PlayList(String UUID2, String name, PlayImage image, String createPlayerName, String createPlayerUUID, String timeStamp, boolean anyone, List<String> ownerPlayerUUIDs) {
        this.UUID = UUID2;
        this.name = name;
        this.createPlayerName = createPlayerName;
        this.createPlayerUUID = createPlayerUUID;
        this.timeStamp = timeStamp;
        this.Anyone = anyone;
        this.image = image;
        this.ownerPlayerUUIDs = ownerPlayerUUIDs;
    }

    public void read(CompoundNBT tag) {
        this.name = tag.func_74779_i("Name");
        this.createPlayerName = tag.func_74779_i("CreatePlayerName");
        this.createPlayerUUID = tag.func_74779_i("CreatePlayerUUID");
        this.timeStamp = tag.func_74779_i("TimeStamp");
        this.Anyone = tag.func_74767_n("Anyone");
        this.image = new PlayImage(tag.func_74775_l("Image"));
        this.ownerPlayerUUIDs = IKSGNBTUtil.readStringList((CompoundNBT)tag.func_74775_l("OwnerPlayerUUID"));
    }

    public CompoundNBT write(CompoundNBT tag) {
        tag.func_74778_a("Name", this.name);
        tag.func_74778_a("CreatePlayerName", this.createPlayerName);
        tag.func_74778_a("CreatePlayerUUID", this.createPlayerUUID);
        tag.func_74778_a("TimeStamp", this.timeStamp);
        tag.func_74757_a("Anyone", this.Anyone);
        tag.func_218657_a("Image", (INBT)this.image.write(new CompoundNBT()));
        tag.func_218657_a("OwnerPlayerUUID", (INBT)IKSGNBTUtil.writeStringList((CompoundNBT)new CompoundNBT(), this.ownerPlayerUUIDs));
        return tag;
    }

    public List<String> getOwnerPlayerUUIDs() {
        return this.ownerPlayerUUIDs;
    }

    public String getName() {
        return this.name;
    }

    public PlayImage getImage() {
        return this.image;
    }

    public String getUUID() {
        return this.UUID;
    }

    public boolean isAnyone() {
        return this.Anyone;
    }

    public String getCreatePlayerName() {
        return this.createPlayerName;
    }

    public String getCreatePlayerUUID() {
        return this.createPlayerUUID;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public void setAnyone(boolean anyone) {
        this.Anyone = anyone;
    }

    public void setCreatePlayerName(String createPlayerName) {
        this.createPlayerName = createPlayerName;
    }

    public void setCreatePlayerUUID(String createPlayerUUID) {
        this.createPlayerUUID = createPlayerUUID;
    }

    public void setImage(PlayImage image) {
        this.image = image;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOwnerPlayerUUIDs(List<String> ownerPlayerUUIDs) {
        this.ownerPlayerUUIDs = ownerPlayerUUIDs;
    }

    public void setTimeStamp(String timeStamp) {
        this.timeStamp = timeStamp;
    }

    public static void addPlayList(PlayList plst) {
        WorldDataManager.instance().getWorldData(IMPWorldData.PLAYLIST_DATA).func_74775_l("playlists").func_218657_a(plst.getUUID(), (INBT)plst.write(new CompoundNBT()));
    }

    public static void setPlayList(PlayList plst) {
        PlayList.removePlayList(plst, false);
        PlayList.addPlayList(plst);
    }

    public static void removePlayList(PlayList plst, boolean rejoin) {
        if (rejoin) {
            CompoundNBT plutag = WorldDataManager.instance().getWorldData(IMPWorldData.PLAYLIST_DATA).func_74775_l("players");
            ArrayList stars = new ArrayList(plutag.func_150296_c());
            stars.forEach(n -> {
                CompoundNBT tag = plutag.func_74775_l(n).func_74775_l("playlist");
                for (int i = 0; i < tag.func_150296_c().size(); ++i) {
                    if (!tag.func_74779_i(String.valueOf(i)).equals(plst.getUUID())) continue;
                    tag.func_82580_o(String.valueOf(i));
                }
            });
        }
        WorldDataManager.instance().getWorldData(IMPWorldData.PLAYLIST_DATA).func_74775_l("playlists").func_82580_o(plst.getUUID());
    }

    public static void addPlayerToPlayList(ServerPlayerEntity player, PlayList list) {
        IamMusicPlayer.LOGGER.info(IKSGPlayerUtil.getUserName((PlayerEntity)player) + " Join PlayList(" + list.getName() + ")");
        String pluuid = IKSGPlayerUtil.getUUID((PlayerEntity)player);
        CompoundNBT pltag = WorldDataManager.instance().getWorldData(IMPWorldData.PLAYLIST_DATA).func_74775_l("players");
        CompoundNBT plutag = null;
        plutag = !pltag.func_74764_b(pluuid) ? new CompoundNBT() : pltag.func_74775_l(pluuid);
        plutag.func_218657_a("playlist", (INBT)IKSGNBTUtil.addStringList((CompoundNBT)plutag.func_74775_l("playlist"), (String)list.getUUID()));
        pltag.func_218657_a(pluuid, (INBT)plutag);
    }

    public void addPlayerToPlayList(ServerPlayerEntity playerEntity) {
        PlayList.addPlayerToPlayList(playerEntity, this);
    }

    public static PlayList getPlayListByUUID(String uuid) {
        if (ALL.getUUID().equals(uuid)) {
            return ALL;
        }
        CompoundNBT pltag = WorldDataManager.instance().getWorldData(IMPWorldData.PLAYLIST_DATA).func_74775_l("playlists");
        if (!pltag.func_74764_b(uuid)) {
            return null;
        }
        return new PlayList(uuid, pltag.func_74775_l(uuid));
    }

    public static PlayList getPlayListByMusic(PlayMusic music) {
        List<PlayList> lists = PlayList.getAllPlayList();
        for (PlayList list : lists) {
            if (!PlayMusic.getIncludedPlayMusics(list).contains(music)) continue;
            return list;
        }
        return null;
    }

    public static List<PlayList> getAllPlayList() {
        ArrayList<PlayList> list = new ArrayList<PlayList>();
        CompoundNBT pltag = WorldDataManager.instance().getWorldData(IMPWorldData.PLAYLIST_DATA).func_74775_l("playlists");
        pltag.func_150296_c().forEach(n -> list.add(PlayList.getPlayListByUUID(n)));
        return list;
    }

    public static List<PlayList> getJoinedPlayLists(ServerPlayerEntity player) {
        String uuid;
        ArrayList<PlayList> list = new ArrayList<PlayList>();
        CompoundNBT pltag = WorldDataManager.instance().getWorldData(IMPWorldData.PLAYLIST_DATA).func_74775_l("players");
        if (!pltag.func_74764_b(uuid = IKSGPlayerUtil.getUUID((PlayerEntity)player))) {
            return list;
        }
        List sts = IKSGNBTUtil.readStringList((CompoundNBT)pltag.func_74775_l(uuid).func_74775_l("playlist"));
        sts.forEach(n -> list.add(PlayList.getPlayListByUUID(n)));
        return list;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof PlayList && ((PlayList)obj).getUUID().equals(this.getUUID());
    }
}

