/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.music.resource;

import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import red.felnull.otyacraftengine.data.INBTReadWriter;

public class PlayLocation
implements INBTReadWriter {
    public static final PlayLocation EMPTY = new PlayLocation(LocationType.EMPTY, "");
    private LocationType locationType;
    private String idOrURL;

    public PlayLocation(LocationType type, String idOrURL) {
        this.locationType = type;
        this.idOrURL = idOrURL;
    }

    public PlayLocation(CompoundNBT tag) {
        this.read(tag);
    }

    public void read(CompoundNBT tag) {
        this.locationType = LocationType.getLocationTypeByName(tag.func_74779_i("LocationType"));
        this.idOrURL = tag.func_74779_i("IdOrURL");
    }

    public CompoundNBT write(CompoundNBT tag) {
        tag.func_74778_a("LocationType", this.locationType.getNmae());
        tag.func_74778_a("IdOrURL", this.idOrURL);
        return tag;
    }

    public LocationType getLocationType() {
        return this.locationType;
    }

    public String getIdOrURL() {
        return this.idOrURL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayLocation that = (PlayLocation)o;
        return this.locationType == that.locationType && Objects.equals(this.idOrURL, that.idOrURL);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.locationType, this.idOrURL});
    }

    public static enum LocationType {
        EMPTY("empty"),
        WORLD_FILE("world_file"),
        URL("url"),
        YOUTUBE("youtube");

        private final String nmae;

        private LocationType(String name) {
            this.nmae = name;
        }

        public String getNmae() {
            return this.nmae;
        }

        public static LocationType getLocationTypeByName(String name) {
            for (LocationType it : LocationType.values()) {
                if (!it.getNmae().equals(name)) continue;
                return it;
            }
            return EMPTY;
        }
    }
}

