/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.tileentity;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import red.felnull.imp.container.CassetteDeckContainer;
import red.felnull.imp.item.ParabolicAntennaItem;
import red.felnull.imp.music.resource.PlayMusic;
import red.felnull.imp.tileentity.IMPAbstractPAPLEquipmentTileEntity;
import red.felnull.imp.tileentity.IMPTileEntityTypes;
import red.felnull.imp.util.ItemHelper;

public class CassetteDeckTileEntity
extends IMPAbstractPAPLEquipmentTileEntity {
    private PlayMusic writePlayMusic = PlayMusic.EMPTY;
    private Screen currentScreen = Screen.OFF;
    private int progres;
    private int prevProgres;

    public CassetteDeckTileEntity() {
        super(IMPTileEntityTypes.CASSETTE_DECK);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.cassette_deck");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new CassetteDeckContainer(id, player, (IInventory)this, this.func_174877_v());
    }

    @Override
    protected int getInventorySize() {
        return 4;
    }

    @Override
    public void readByIKSG(BlockState state, CompoundNBT tag) {
        super.readByIKSG(state, tag);
        this.currentScreen = Screen.getScreenByName(tag.func_74779_i("CurrentScreen"));
        this.writePlayMusic = new PlayMusic(tag.func_74779_i("WritePlayMusicUUID"), tag.func_74775_l("WritePlayMusic"));
        this.progres = tag.func_74762_e("Progres");
        this.prevProgres = tag.func_74762_e("PrevProgres");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74778_a("CurrentScreen", this.currentScreen.getName());
        tag.func_218657_a("WritePlayMusic", (INBT)this.writePlayMusic.write(new CompoundNBT()));
        tag.func_74778_a("WritePlayMusicUUID", this.writePlayMusic.getUUID());
        tag.func_74768_a("Progres", this.progres);
        tag.func_74768_a("PrevProgres", this.prevProgres);
        return tag;
    }

    public void setScreen(Screen screen) {
        this.currentScreen = screen;
    }

    public Screen getScreen() {
        return this.currentScreen;
    }

    public PlayMusic getWritePlayMusic() {
        return this.writePlayMusic;
    }

    public int getProgres() {
        return this.progres;
    }

    public int getPrevProgres() {
        return this.prevProgres;
    }

    public int getWriteProgresAll() {
        return 300;
    }

    protected int getWriteSpeedMagnification() {
        if (this.getPAntenna().func_77973_b() instanceof ParabolicAntennaItem) {
            return ((ParabolicAntennaItem)this.getPAntenna().func_77973_b()).getWriteSpeedMagnification();
        }
        return 1;
    }

    protected int getWriteSpeed() {
        return this.getWriteSpeedMagnification();
    }

    public int getErasureProgresAll() {
        return 100;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.isOn()) {
                if (this.currentScreen == Screen.OFF) {
                    this.currentScreen = Screen.SELECTION;
                }
                if ((this.currentScreen == Screen.WRITE_1 || this.currentScreen == Screen.WRITE_2) && this.getPAntenna().func_190926_b()) {
                    this.currentScreen = Screen.WRITE_NO_ANTENNA;
                }
                if (this.currentScreen == Screen.WRITE_NO_ANTENNA && !this.getPAntenna().func_190926_b()) {
                    this.currentScreen = Screen.WRITE_1;
                }
                if (this.currentScreen == Screen.WRITE_2) {
                    if (this.getCassetteTape().func_190926_b()) {
                        this.currentScreen = Screen.WRITE_1;
                    }
                    if (this.progres < this.getWriteProgresAll()) {
                        this.progres += this.getWriteSpeed();
                    }
                    this.prevProgres = this.progres;
                    if (this.prevProgres < this.getWriteProgresAll()) {
                        this.prevProgres += this.getWriteSpeed();
                    }
                    if (this.progres >= this.getWriteProgresAll()) {
                        this.writeCassetteTape();
                        this.currentScreen = Screen.WRITE_1;
                    }
                } else if (this.currentScreen == Screen.ERASE) {
                    if (this.getCassetteTape().func_190926_b() || !ItemHelper.isWrittenCassetteTape(this.getCassetteTape())) {
                        this.currentScreen = Screen.SELECTION;
                    }
                    if (this.progres < this.getErasureProgresAll()) {
                        ++this.progres;
                    }
                    this.prevProgres = this.progres;
                    if (this.prevProgres < this.getErasureProgresAll()) {
                        ++this.prevProgres;
                    }
                    if (this.progres >= this.getErasureProgresAll()) {
                        this.erasureCassetteTape();
                        this.currentScreen = Screen.SELECTION;
                    }
                } else if (this.currentScreen == Screen.COPY) {
                    if (this.getCassetteTape().func_190926_b() || this.getSubCassetteTape().func_190926_b() || !ItemHelper.isWrittenCassetteTape(this.getSubCassetteTape())) {
                        this.currentScreen = Screen.SELECTION;
                    }
                    if (this.progres < this.getErasureProgresAll()) {
                        ++this.progres;
                    }
                    this.prevProgres = this.progres;
                    if (this.prevProgres < this.getErasureProgresAll()) {
                        ++this.prevProgres;
                    }
                    if (this.progres >= this.getErasureProgresAll()) {
                        this.copyCassetteTape();
                        this.currentScreen = Screen.SELECTION;
                    }
                } else {
                    this.progres = 0;
                    this.prevProgres = 0;
                }
            } else {
                if (this.currentScreen != Screen.OFF) {
                    this.currentScreen = Screen.OFF;
                }
                this.progres = 0;
                this.prevProgres = 0;
            }
        }
    }

    protected void writeCassetteTape() {
        this.setCassetteTape(ItemHelper.writtenCassetteTape(this.getCassetteTape(), this.getWritePlayMusic()));
    }

    protected void erasureCassetteTape() {
        this.setCassetteTape(ItemHelper.erasureCassetteTape(this.getCassetteTape()));
    }

    protected void copyCassetteTape() {
        if (!this.getSubCassetteTape().func_190926_b()) {
            PlayMusic music = ItemHelper.getPlayMusicByItem(this.getSubCassetteTape());
            this.setCassetteTape(ItemHelper.writtenCassetteTape(this.getCassetteTape(), music));
        }
    }

    public ItemStack getCassetteTape() {
        return this.func_70301_a(1);
    }

    public ItemStack getSubCassetteTape() {
        return this.func_70301_a(2);
    }

    public void setCassetteTape(ItemStack stack) {
        this.getItems().set(1, (Object)stack);
    }

    @Override
    public CompoundNBT instructionFromClient(ServerPlayerEntity player, String s, CompoundNBT tag) {
        if (s.equals("Mode")) {
            this.setScreen(Screen.getScreenByName(tag.func_74779_i("name")));
        } else if (s.equals("PlayMusicSet")) {
            this.setWritePlayMusic(tag.func_74779_i("UUID"));
        }
        return super.instructionFromClient(player, s, tag);
    }

    public void setWritePlayMusic(String UUID2) {
        this.writePlayMusic = PlayMusic.getPlayMusicByUUID(UUID2);
    }

    public static enum Screen {
        OFF("off"),
        SELECTION("selection"),
        PLAY("play"),
        WRITE_1("write_1"),
        WRITE_2("write_2"),
        ERASE("erase"),
        COPY("copy"),
        WRITE_NO_ANTENNA("write_no_antenna");

        private final String name;

        private Screen(String name) {
            this.name = name;
        }

        public static Screen getScreenByName(String name) {
            for (Screen sc : Screen.values()) {
                if (!sc.getName().equals(name)) continue;
                return sc;
            }
            return OFF;
        }

        public String getName() {
            return this.name;
        }

        public ResourceLocation getTexLocation() {
            return new ResourceLocation("iammusicplayer", "textures/gui/cassette_deck_screen/" + this.getName() + ".png");
        }
    }
}

