/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.tileentity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import red.felnull.imp.data.PlayListGuildManeger;
import red.felnull.imp.data.PlayMusicManeger;
import red.felnull.imp.music.resource.PlayList;
import red.felnull.imp.tileentity.IMPAbstractPAEquipmentTileEntity;
import red.felnull.otyacraftengine.util.IKSGNBTUtil;
import red.felnull.otyacraftengine.util.IKSGPlayerUtil;

public abstract class IMPAbstractPAPLEquipmentTileEntity
extends IMPAbstractPAEquipmentTileEntity {
    private Map<String, String> plyerLastScreens = new HashMap<String, String>();

    protected IMPAbstractPAPLEquipmentTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
    }

    public String getLastPlayList(PlayerEntity pl) {
        String uuid = IKSGPlayerUtil.getUUID((PlayerEntity)pl);
        if (this.plyerLastScreens.containsKey(uuid)) {
            return this.plyerLastScreens.get(uuid);
        }
        return "";
    }

    @Override
    public void readByIKSG(BlockState state, CompoundNBT tag) {
        super.readByIKSG(state, tag);
        this.plyerLastScreens = IKSGNBTUtil.readStringMap((CompoundNBT)tag.func_74775_l("PlyerLastScreens"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("PlyerLastScreens", (INBT)IKSGNBTUtil.writeStringMap((CompoundNBT)new CompoundNBT(), this.plyerLastScreens));
        return tag;
    }

    @Override
    public CompoundNBT instructionFromClient(ServerPlayerEntity player, String s, CompoundNBT tag) {
        if (s.equals("LastPlayListSet")) {
            this.setLastPlayList((PlayerEntity)player, tag.func_74779_i("uuid"));
        } else {
            if (s.equals("PlayListUpdate")) {
                return this.getUpdatePlayListTag(player);
            }
            if (s.equals("PlayMusicUpdate")) {
                return this.getUpdatePlayMusicTag(player, tag.func_74779_i("uuid"));
            }
        }
        return super.instructionFromClient(player, s, tag);
    }

    private CompoundNBT getUpdatePlayMusicTag(ServerPlayerEntity playerEntity, String uuid) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("uuid", uuid);
        tag.func_218657_a("list", (INBT)PlayMusicManeger.instance().getAllPlayMusicNBT(playerEntity, PlayList.getPlayListByUUID(uuid)));
        return tag;
    }

    private CompoundNBT getUpdatePlayListTag(ServerPlayerEntity player) {
        return PlayListGuildManeger.instance().getJoinedPlayListsNBT(player);
    }

    public void setLastPlayList(PlayerEntity pl, String uuid) {
        this.plyerLastScreens.put(IKSGPlayerUtil.getUUID((PlayerEntity)pl), uuid);
    }
}

