/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.natives.opus;

import com.sedmelluq.discord.lavaplayer.natives.opus.OpusEncoderLibrary;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.NativeResourceHolder;

public class OpusEncoder
extends NativeResourceHolder {
    private final OpusEncoderLibrary library = OpusEncoderLibrary.getInstance();
    private final long instance;

    public OpusEncoder(int sampleRate, int channels, int quality) {
        this.instance = this.library.create(sampleRate, channels, 2049, quality);
        if (this.instance == 0L) {
            throw new IllegalStateException("Failed to create an encoder instance");
        }
    }

    public int encode(ShortBuffer directInput, int frameSize, ByteBuffer directOutput) {
        this.checkNotReleased();
        if (!directInput.isDirect() || !directOutput.isDirect()) {
            throw new IllegalArgumentException("Arguments must be direct buffers.");
        }
        directOutput.clear();
        int result = this.library.encode(this.instance, directInput, frameSize, directOutput, directOutput.capacity());
        if (result < 0) {
            throw new IllegalStateException("Encoding failed with error " + result);
        }
        directOutput.position(result);
        directOutput.flip();
        return result;
    }

    @Override
    protected void freeResources() {
        this.library.destroy(this.instance);
    }
}

