/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetection;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacAudioTrack;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacFileLoader;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.flac.FlacTrackInfo;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;
import java.io.IOException;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class FlacContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(FlacContainerProbe.class);
    private static final String TITLE_TAG = "TITLE";
    private static final String ARTIST_TAG = "ARTIST";

    @Override
    public String getName() {
        return "flac";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return false;
    }

    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        if (!MediaContainerDetection.checkNextBytes(inputStream, FlacFileLoader.FLAC_CC)) {
            return null;
        }
        log.debug("Track {} is a FLAC file.", (Object)reference.identifier);
        FlacTrackInfo fileInfo = new FlacFileLoader(inputStream).parseHeaders();
        AudioTrackInfo trackInfo = AudioTrackInfoBuilder.create(reference, inputStream).setTitle(fileInfo.tags.get(TITLE_TAG)).setAuthor(fileInfo.tags.get(ARTIST_TAG)).setLength(fileInfo.duration).build();
        return MediaContainerDetectionResult.supportedFormat(this, null, trackInfo);
    }

    @Override
    public AudioTrack createTrack(String parameters, AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new FlacAudioTrack(trackInfo, inputStream);
    }
}

