/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.matroska.format;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaElement;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaElementType;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.matroska.format.MatroskaFileReader;
import java.io.IOException;

public class MatroskaFileTrack {
    public final int index;
    public final Type type;
    public final long trackUid;
    public final String name;
    public final String codecId;
    public final byte[] codecPrivate;
    public final AudioDetails audio;

    public MatroskaFileTrack(int index, Type type, long trackUid, String name, String codecId, byte[] codecPrivate, AudioDetails audio) {
        this.index = index;
        this.type = type;
        this.trackUid = trackUid;
        this.name = name;
        this.codecId = codecId;
        this.codecPrivate = codecPrivate;
        this.audio = audio;
    }

    public static MatroskaFileTrack parse(MatroskaElement trackElement, MatroskaFileReader reader) throws IOException {
        MatroskaElement child;
        Builder builder = new Builder();
        while ((child = reader.readNextElement(trackElement)) != null) {
            if (child.is(MatroskaElementType.TrackNumber)) {
                builder.index = reader.asInteger(child);
            } else if (child.is(MatroskaElementType.TrackUid)) {
                builder.trackUid = reader.asLong(child);
            } else if (child.is(MatroskaElementType.TrackType)) {
                builder.type = Type.fromId(reader.asInteger(child));
            } else if (child.is(MatroskaElementType.Name)) {
                builder.name = reader.asString(child);
            } else if (child.is(MatroskaElementType.CodecId)) {
                builder.codecId = reader.asString(child);
            } else if (child.is(MatroskaElementType.CodecPrivate)) {
                Builder.access$602(builder, reader.asBytes(child));
            } else if (child.is(MatroskaElementType.Audio)) {
                builder.audio = MatroskaFileTrack.parseAudioElement(child, reader);
            }
            reader.skip(child);
        }
        return builder.build();
    }

    private static AudioDetails parseAudioElement(MatroskaElement audioElement, MatroskaFileReader reader) throws IOException {
        MatroskaElement child;
        AudioBuilder builder = new AudioBuilder();
        while ((child = reader.readNextElement(audioElement)) != null) {
            if (child.is(MatroskaElementType.SamplingFrequency)) {
                builder.samplingFrequency = reader.asFloat(child);
            } else if (child.is(MatroskaElementType.OutputSamplingFrequency)) {
                builder.outputSamplingFrequency = reader.asFloat(child);
            } else if (child.is(MatroskaElementType.Channels)) {
                builder.channels = reader.asInteger(child);
            } else if (child.is(MatroskaElementType.BitDepth)) {
                builder.bitDepth = reader.asInteger(child);
            }
            reader.skip(child);
        }
        return builder.build();
    }

    private static class AudioBuilder {
        private float samplingFrequency;
        private float outputSamplingFrequency;
        private int channels;
        private int bitDepth;

        private AudioBuilder() {
        }

        private AudioDetails build() {
            return new AudioDetails(this.samplingFrequency, this.outputSamplingFrequency, this.channels, this.bitDepth);
        }
    }

    private static class Builder {
        private int index;
        private Type type;
        private long trackUid;
        private String name;
        private String codecId;
        private byte[] codecPrivate;
        private AudioDetails audio;

        private Builder() {
        }

        private MatroskaFileTrack build() {
            return new MatroskaFileTrack(this.index, this.type, this.trackUid, this.name, this.codecId, this.codecPrivate, this.audio);
        }

        static /* synthetic */ byte[] access$602(Builder x0, byte[] x1) {
            x0.codecPrivate = x1;
            return x1;
        }
    }

    public static class AudioDetails {
        public final float samplingFrequency;
        public final float outputSamplingFrequency;
        public final int channels;
        public final int bitDepth;

        public AudioDetails(float samplingFrequency, float outputSamplingFrequency, int channels, int bitDepth) {
            this.samplingFrequency = samplingFrequency;
            this.outputSamplingFrequency = outputSamplingFrequency;
            this.channels = channels;
            this.bitDepth = bitDepth;
        }
    }

    public static enum Type {
        VIDEO(1L),
        AUDIO(2L),
        COMPLEX(3L),
        LOGO(16L),
        SUBTITLE(17L),
        BUTTONS(18L),
        CONTROL(32L);

        public final long id;

        private Type(long id) {
            this.id = id;
        }

        public static Type fromId(long id) {
            for (Type entry : (Type[])Type.class.getEnumConstants()) {
                if (entry.id != id) continue;
                return entry;
            }
            return null;
        }
    }
}

