/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.container.mp3;

import com.sedmelluq.discord.lavaplayer.natives.mp3.Mp3Decoder;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public class Mp3FrameReader {
    private final SeekableInputStream inputStream;
    private final DataInput dataInput;
    private final byte[] scanBuffer;
    private final byte[] frameBuffer;
    private int frameSize;
    private int frameBufferPosition;
    private int scanBufferPosition;
    private boolean frameHeaderRead;

    public Mp3FrameReader(SeekableInputStream inputStream, byte[] frameBuffer) {
        this.inputStream = inputStream;
        this.dataInput = new DataInputStream(inputStream);
        this.scanBuffer = new byte[16];
        this.frameBuffer = frameBuffer;
    }

    public boolean scanForFrame(int bytesToCheck, boolean throwOnLimit) throws IOException {
        int bytesInBuffer = this.scanBufferPosition;
        this.scanBufferPosition = 0;
        if (this.parseFrameAt(bytesInBuffer)) {
            this.frameHeaderRead = true;
            return true;
        }
        return this.runFrameScanLoop(bytesToCheck - bytesInBuffer, bytesInBuffer, throwOnLimit);
    }

    private boolean runFrameScanLoop(int bytesToCheck, int bytesInBuffer, boolean throwOnLimit) throws IOException {
        while (bytesToCheck > 0) {
            for (int i = bytesInBuffer; i < this.scanBuffer.length && bytesToCheck > 0; ++i, --bytesToCheck) {
                int next = this.inputStream.read();
                if (next == -1) {
                    return false;
                }
                this.scanBuffer[i] = (byte)(next & 0xFF);
                if (!this.parseFrameAt(i + 1)) continue;
                this.frameHeaderRead = true;
                return true;
            }
            bytesInBuffer = this.copyScanBufferEndToBeginning();
        }
        if (throwOnLimit) {
            throw new IllegalStateException("Mp3 frame not found.");
        }
        return false;
    }

    private int copyScanBufferEndToBeginning() {
        for (int i = 0; i < 3; ++i) {
            this.scanBuffer[i] = this.scanBuffer[this.scanBuffer.length - 4 + i + 1];
        }
        return 3;
    }

    private boolean parseFrameAt(int scanOffset) {
        if (scanOffset >= 4 && (this.frameSize = Mp3Decoder.getFrameSize(this.scanBuffer, scanOffset - 4)) > 0) {
            for (int i = 0; i < 4; ++i) {
                this.frameBuffer[i] = this.scanBuffer[scanOffset - 4 + i];
            }
            this.frameBufferPosition = 4;
            return true;
        }
        return false;
    }

    public boolean fillFrameBuffer() throws IOException {
        if (!this.frameHeaderRead && !this.scanForFrame(Integer.MAX_VALUE, true)) {
            return false;
        }
        this.dataInput.readFully(this.frameBuffer, this.frameBufferPosition, this.frameSize - this.frameBufferPosition);
        this.frameBufferPosition = this.frameSize;
        return true;
    }

    public void nextFrame() {
        this.frameHeaderRead = false;
        this.frameBufferPosition = 0;
    }

    public long getFrameStartPosition() {
        return this.inputStream.getPosition() - (long)this.frameBufferPosition;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public void appendToScanBuffer(byte[] data, int offset, int length) {
        System.arraycopy(data, offset, this.scanBuffer, 0, length);
        this.scanBufferPosition = length;
    }
}

