/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.filter.PcmFilterFactory;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioPlayerOptions;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.event.AudioEvent;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.event.PlayerPauseEvent;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.event.PlayerResumeEvent;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.event.TrackEndEvent;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.event.TrackExceptionEvent;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.event.TrackStartEvent;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.event.TrackStuckEvent;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.CopyOnUpdateIdentityList;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameProviderTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import red.felnull.imp.libs.org.slf4j.Logger;
import red.felnull.imp.libs.org.slf4j.LoggerFactory;

public class DefaultAudioPlayer
implements AudioPlayer,
TrackStateListener {
    private static final Logger log = LoggerFactory.getLogger(AudioPlayer.class);
    private volatile InternalAudioTrack activeTrack;
    private volatile long lastRequestTime;
    private volatile long lastReceiveTime;
    private volatile boolean stuckEventSent;
    private volatile InternalAudioTrack shadowTrack;
    private final AtomicBoolean paused;
    private final DefaultAudioPlayerManager manager;
    private final CopyOnUpdateIdentityList<AudioEventListener> listeners;
    private final Object trackSwitchLock;
    private final AudioPlayerOptions options;

    public DefaultAudioPlayer(DefaultAudioPlayerManager manager) {
        this.manager = manager;
        this.activeTrack = null;
        this.paused = new AtomicBoolean();
        this.listeners = new CopyOnUpdateIdentityList();
        this.trackSwitchLock = new Object();
        this.options = new AudioPlayerOptions();
    }

    @Override
    public AudioTrack getPlayingTrack() {
        return this.activeTrack;
    }

    @Override
    public void playTrack(AudioTrack track) {
        this.startTrack(track, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startTrack(AudioTrack track, boolean noInterrupt) {
        InternalAudioTrack newTrack = (InternalAudioTrack)track;
        Object object = this.trackSwitchLock;
        synchronized (object) {
            InternalAudioTrack previousTrack = this.activeTrack;
            if (noInterrupt && previousTrack != null) {
                return false;
            }
            this.activeTrack = newTrack;
            this.lastRequestTime = System.currentTimeMillis();
            this.lastReceiveTime = System.nanoTime();
            this.stuckEventSent = false;
            if (previousTrack != null) {
                previousTrack.stop();
                this.dispatchEvent(new TrackEndEvent(this, previousTrack, newTrack == null ? AudioTrackEndReason.STOPPED : AudioTrackEndReason.REPLACED));
                this.shadowTrack = previousTrack;
            }
        }
        if (newTrack == null) {
            this.shadowTrack = null;
            return false;
        }
        this.dispatchEvent(new TrackStartEvent(this, newTrack));
        this.manager.executeTrack(this, newTrack, this.manager.getConfiguration(), this.options);
        return true;
    }

    @Override
    public void stopTrack() {
        this.stopWithReason(AudioTrackEndReason.STOPPED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWithReason(AudioTrackEndReason reason) {
        this.shadowTrack = null;
        Object object = this.trackSwitchLock;
        synchronized (object) {
            InternalAudioTrack previousTrack = this.activeTrack;
            this.activeTrack = null;
            if (previousTrack != null) {
                previousTrack.stop();
                this.dispatchEvent(new TrackEndEvent(this, previousTrack, reason));
            }
        }
    }

    private AudioFrame provideShadowFrame() {
        InternalAudioTrack shadow = this.shadowTrack;
        AudioFrame frame = null;
        if (shadow != null && (frame = shadow.provide()) != null && frame.isTerminator()) {
            this.shadowTrack = null;
            frame = null;
        }
        return frame;
    }

    private boolean provideShadowFrame(MutableAudioFrame targetFrame) {
        InternalAudioTrack shadow = this.shadowTrack;
        if (shadow != null && shadow.provide(targetFrame)) {
            if (targetFrame.isTerminator()) {
                this.shadowTrack = null;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public AudioFrame provide() {
        return AudioFrameProviderTools.delegateToTimedProvide(this);
    }

    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        InternalAudioTrack track;
        this.lastRequestTime = System.currentTimeMillis();
        if (timeout == 0L && this.paused.get()) {
            return null;
        }
        while ((track = this.activeTrack) != null) {
            AudioFrame frame;
            AudioFrame audioFrame = frame = timeout > 0L ? track.provide(timeout, unit) : track.provide();
            if (frame != null) {
                this.lastReceiveTime = System.nanoTime();
                this.shadowTrack = null;
                if (frame.isTerminator()) {
                    this.handleTerminator(track);
                    continue;
                }
            } else if (timeout == 0L) {
                this.checkStuck(track);
                frame = this.provideShadowFrame();
            }
            return frame;
        }
        return null;
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame) {
        try {
            return this.provide(targetFrame, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            ExceptionTools.keepInterrupted(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        InternalAudioTrack track;
        this.lastRequestTime = System.currentTimeMillis();
        if (timeout == 0L && this.paused.get()) {
            return false;
        }
        while ((track = this.activeTrack) != null) {
            if (timeout > 0L ? track.provide(targetFrame, timeout, unit) : track.provide(targetFrame)) {
                this.lastReceiveTime = System.nanoTime();
                this.shadowTrack = null;
                if (targetFrame.isTerminator()) {
                    this.handleTerminator(track);
                    continue;
                }
                return true;
            }
            if (timeout == 0L) {
                this.checkStuck(track);
                return this.provideShadowFrame(targetFrame);
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTerminator(InternalAudioTrack track) {
        Object object = this.trackSwitchLock;
        synchronized (object) {
            if (this.activeTrack == track) {
                this.activeTrack = null;
                this.dispatchEvent(new TrackEndEvent(this, track, track.getActiveExecutor().failedBeforeLoad() ? AudioTrackEndReason.LOAD_FAILED : AudioTrackEndReason.FINISHED));
            }
        }
    }

    private void checkStuck(AudioTrack track) {
        if (!this.stuckEventSent && System.nanoTime() - this.lastReceiveTime > this.manager.getTrackStuckThresholdNanos()) {
            this.stuckEventSent = true;
            StackTraceElement[] stackTrace = this.getStackTrace(track);
            long threshold = TimeUnit.NANOSECONDS.toMillis(this.manager.getTrackStuckThresholdNanos());
            this.dispatchEvent(new TrackStuckEvent(this, track, threshold, stackTrace));
        }
    }

    private StackTraceElement[] getStackTrace(AudioTrack track) {
        AudioTrackExecutor executor;
        if (track instanceof InternalAudioTrack && (executor = ((InternalAudioTrack)track).getActiveExecutor()) instanceof LocalAudioTrackExecutor) {
            return ((LocalAudioTrackExecutor)executor).getStackTrace();
        }
        return null;
    }

    @Override
    public int getVolume() {
        return this.options.volumeLevel.get();
    }

    @Override
    public void setVolume(int volume) {
        this.options.volumeLevel.set(Math.min(1000, Math.max(0, volume)));
    }

    @Override
    public void setFilterFactory(PcmFilterFactory factory) {
        this.options.filterFactory.set(factory);
    }

    @Override
    public void setFrameBufferDuration(Integer duration) {
        if (duration != null) {
            duration = Math.max(200, duration);
        }
        this.options.frameBufferDuration.set(duration);
    }

    @Override
    public boolean isPaused() {
        return this.paused.get();
    }

    @Override
    public void setPaused(boolean value) {
        if (this.paused.compareAndSet(!value, value)) {
            if (value) {
                this.dispatchEvent(new PlayerPauseEvent(this));
            } else {
                this.dispatchEvent(new PlayerResumeEvent(this));
                this.lastReceiveTime = System.nanoTime();
            }
        }
    }

    @Override
    public void destroy() {
        this.stopTrack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(AudioEventListener listener) {
        Object object = this.trackSwitchLock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(AudioEventListener listener) {
        Object object = this.trackSwitchLock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(AudioEvent event) {
        log.debug("Firing an event with class {}", (Object)event.getClass().getSimpleName());
        Object object = this.trackSwitchLock;
        synchronized (object) {
            for (AudioEventListener listener : this.listeners.items) {
                try {
                    listener.onEvent(event);
                }
                catch (Exception e) {
                    log.error("Handler of event {} threw an exception.", (Object)event, (Object)e);
                }
            }
        }
    }

    @Override
    public void onTrackException(AudioTrack track, FriendlyException exception) {
        this.dispatchEvent(new TrackExceptionEvent(this, track, exception));
    }

    @Override
    public void onTrackStuck(AudioTrack track, long thresholdMs) {
        this.dispatchEvent(new TrackStuckEvent(this, track, thresholdMs, null));
    }

    @Override
    public void checkCleanup(long threshold) {
        AudioTrack track = this.getPlayingTrack();
        if (track != null && System.currentTimeMillis() - this.lastRequestTime >= threshold) {
            log.debug("Triggering cleanup on an audio player playing track {}", (Object)track);
            this.stopWithReason(AudioTrackEndReason.CLEANUP);
        }
    }
}

