/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.getyarn;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.getyarn.GetyarnAudioTrack;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.ThreadLocalHttpInterfaceManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;
import dev.felnull.imp.libs.org.apache.commons.io.IOUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import red.felnull.imp.libs.org.apache.http.client.config.RequestConfig;
import red.felnull.imp.libs.org.apache.http.client.methods.CloseableHttpResponse;
import red.felnull.imp.libs.org.apache.http.client.methods.HttpGet;
import red.felnull.imp.libs.org.apache.http.impl.client.HttpClientBuilder;
import red.felnull.imp.libs.org.jsoup.Jsoup;
import red.felnull.imp.libs.org.jsoup.nodes.Document;

public class GetyarnAudioSourceManager
implements HttpConfigurable,
AudioSourceManager {
    private static final Pattern GETYARN_REGEX = Pattern.compile("(?:http://|https://(?:www\\.)?)?getyarn\\.io/yarn-clip/(.*)");
    private final HttpInterfaceManager httpInterfaceManager = new ThreadLocalHttpInterfaceManager(HttpClientTools.createSharedCookiesHttpBuilder().setRedirectStrategy(new HttpClientTools.NoRedirectsStrategy()), HttpClientTools.DEFAULT_REQUEST_CONFIG);

    @Override
    public String getSourceName() {
        return "getyarn.io";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        Matcher m = GETYARN_REGEX.matcher(reference.identifier);
        if (!m.matches()) {
            return null;
        }
        return this.extractVideoUrlFromPage(reference);
    }

    private AudioTrack createTrack(AudioTrackInfo trackInfo) {
        return new GetyarnAudioTrack(trackInfo, this);
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) {
        return new GetyarnAudioTrack(trackInfo, this);
    }

    @Override
    public void shutdown() {
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioTrack extractVideoUrlFromPage(AudioReference reference) {
        try (CloseableHttpResponse response = this.getHttpInterface().execute(new HttpGet(reference.identifier));){
            String html = IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8);
            Document document = Jsoup.parse(html);
            AudioTrackInfo trackInfo = AudioTrackInfoBuilder.empty().setUri(reference.identifier).setAuthor("Unknown").setIsStream(false).setIdentifier(document.selectFirst("meta[property=og:video:secure_url]").attr("content")).setTitle(document.selectFirst("meta[property=og:title]").attr("content")).build();
            AudioTrack audioTrack = this.createTrack(trackInfo);
            return audioTrack;
        }
        catch (IOException e) {
            throw new FriendlyException("Failed to load info for yarn clip", FriendlyException.Severity.SUSPICIOUS, null);
        }
    }
}

