/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.twitch;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioTrack;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioItem;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import red.felnull.imp.libs.org.apache.http.client.config.RequestConfig;
import red.felnull.imp.libs.org.apache.http.client.methods.HttpGet;
import red.felnull.imp.libs.org.apache.http.client.methods.HttpUriRequest;
import red.felnull.imp.libs.org.apache.http.impl.client.HttpClientBuilder;

public class TwitchStreamAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final String STREAM_NAME_REGEX = "^https://(?:www\\.|go\\.)?twitch.tv/([^/]+)$";
    private static final Pattern streamNameRegex = Pattern.compile("^https://(?:www\\.|go\\.)?twitch.tv/([^/]+)$");
    public static final String DEFAULT_CLIENT_ID = "jzkbprff40iqj646a697cyrvl0zt2m6";
    private final HttpInterfaceManager httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
    private final String twitchClientId;

    public TwitchStreamAudioSourceManager() {
        this(DEFAULT_CLIENT_ID);
    }

    public TwitchStreamAudioSourceManager(String clientId) {
        this.twitchClientId = clientId;
    }

    public String getClientId() {
        return this.twitchClientId;
    }

    @Override
    public String getSourceName() {
        return "twitch";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        String channelId;
        String streamName = TwitchStreamAudioSourceManager.getChannelIdentifierFromUrl(reference.identifier);
        if (streamName == null) {
            return null;
        }
        JsonBrowser accessToken = this.fetchAccessToken(streamName);
        if (accessToken == null || accessToken.get("token").isNull()) {
            return AudioReference.NO_TRACK;
        }
        try {
            JsonBrowser token = JsonBrowser.parse(accessToken.get("token").text());
            channelId = token.get("channel_id").text();
        }
        catch (IOException e) {
            return null;
        }
        JsonBrowser channelInfo = this.fetchStreamChannelInfo(channelId);
        if (channelInfo == null || channelInfo.get("stream").isNull()) {
            return AudioReference.NO_TRACK;
        }
        JsonBrowser channelData = channelInfo.get("stream").get("channel");
        String status = channelData.get("status").text();
        return new TwitchStreamAudioTrack(new AudioTrackInfo(status, streamName, Long.MAX_VALUE, reference.identifier, true, reference.identifier), this);
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        return new TwitchStreamAudioTrack(trackInfo, this);
    }

    public static String getChannelIdentifierFromUrl(String url) {
        Matcher matcher = streamNameRegex.matcher(url);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    public HttpUriRequest createGetRequest(String url) {
        return TwitchStreamAudioSourceManager.addClientHeaders(new HttpGet(url), this.twitchClientId);
    }

    public HttpUriRequest createGetRequest(URI url) {
        return TwitchStreamAudioSourceManager.addClientHeaders(new HttpGet(url), this.twitchClientId);
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    private static HttpUriRequest addClientHeaders(HttpUriRequest request, String clientId) {
        request.setHeader("Accept", "application/vnd.twitchtv.v5+json; charset=UTF-8");
        request.setHeader("Client-ID", clientId);
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonBrowser fetchAccessToken(String name) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            HttpUriRequest request = this.createGetRequest("https://api.twitch.tv/api/channels/" + name + "/access_token");
            JsonBrowser jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, request);
            return jsonBrowser;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading Twitch channel access token failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonBrowser fetchStreamChannelInfo(String channelId) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            HttpUriRequest request = this.createGetRequest("https://api.twitch.tv/kraken/streams/" + channelId + "?stream_type=all");
            JsonBrowser jsonBrowser = HttpClientTools.fetchResponseAsJson(httpInterface, request);
            return jsonBrowser;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading Twitch channel information failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    @Override
    public void shutdown() {
        ExceptionTools.closeWithWarnings(this.httpInterfaceManager);
    }
}

