/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import red.felnull.imp.data.IMPWorldData;
import red.felnull.imp.data.WorldMusicFileDataInfo;
import red.felnull.imp.exception.IMPWorldMusicException;
import red.felnull.otyacraftengine.api.ResponseSender;

public class MusicDownloader {
    private static MusicDownloader INSTANCE;
    public final Map<String, WorldMusicFileDataInfo> WAITINFOUUID = new HashMap<String, WorldMusicFileDataInfo>();
    public final Map<UUID, byte[]> WORLDMUSICBYTE = new HashMap<UUID, byte[]>();

    public static void init() {
        INSTANCE = new MusicDownloader();
    }

    public static MusicDownloader instance() {
        return INSTANCE;
    }

    public WorldMusicFileDataInfo getWorldMusicFileDataInfo(String uuid) throws InterruptedException, IMPWorldMusicException {
        if (Thread.currentThread().getName().equals("Render thread")) {
            throw new IMPWorldMusicException("Render thread is NG");
        }
        this.WAITINFOUUID.put(uuid, null);
        CompoundNBT tag = new CompoundNBT();
        ResponseSender.sendToServer((ResourceLocation)IMPWorldData.WORLDMUSICFILEDATA, (int)0, (String)uuid, (CompoundNBT)tag);
        long fristTime = System.currentTimeMillis();
        while (this.WAITINFOUUID.get(uuid) == null) {
            Thread.sleep(100L);
            if (System.currentTimeMillis() - fristTime <= 10000L) continue;
            throw new IMPWorldMusicException("Time out of response from world");
        }
        if (this.WAITINFOUUID.get(uuid).isError()) {
            throw new IMPWorldMusicException("World Music File is error");
        }
        return this.WAITINFOUUID.get(uuid);
    }

    public UUID byteRequest(String musicUUID, int begin) throws IMPWorldMusicException {
        UUID byteUUID = UUID.randomUUID();
        if (Thread.currentThread().getName().equals("Render thread")) {
            throw new IMPWorldMusicException("Render thread is NG");
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("begin", begin);
        tag.func_74778_a("byteuuid", byteUUID.toString());
        ResponseSender.sendToServer((ResourceLocation)IMPWorldData.WORLDMUSICFILEDATA, (int)1, (String)musicUUID, (CompoundNBT)tag);
        return byteUUID;
    }

    public void byteResponse(UUID byteUUID, byte[] data) {
        this.WORLDMUSICBYTE.put(byteUUID, data);
    }
}

