/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import red.felnull.imp.block.propertie.BoomboxMode;
import red.felnull.imp.client.gui.screen.IMPAbstractEquipmentScreen;
import red.felnull.imp.container.BoomboxContainer;
import red.felnull.imp.tileentity.BoomboxTileEntity;
import red.felnull.imp.util.StringUtils;
import red.felnull.otyacraftengine.client.util.IKSGRenderUtil;

public class BoomboxScreen
extends IMPAbstractEquipmentScreen<BoomboxContainer> {
    public static final ResourceLocation BOOMBOX_GUI_TEXTURES = new ResourceLocation("iammusicplayer", "textures/gui/container/boombox.png");
    private BoomboxButton pauseButton;
    private BoomboxButton stopButton;
    private BoomboxButton playButton;
    private BoomboxButton loopButton;
    private BoomboxButton volDownButton;
    private BoomboxButton volUpButton;
    private BoomboxButton volMuteButton;

    public BoomboxScreen(BoomboxContainer screenContainer, PlayerInventory playerInventory, ITextComponent titleIn) {
        super(screenContainer, playerInventory, titleIn);
        this.field_146999_f = 214;
        this.field_147000_g = 165;
        this.field_238745_s_ = this.field_147000_g - 94;
    }

    @Override
    public void initByIKSG() {
        super.initByIKSG();
        this.pauseButton = this.addBoomboxButton(25, 17, 0, n -> {
            if (!this.getCassetteTape().func_190926_b() && this.getMode() == BoomboxMode.PLAY) {
                this.insMode(BoomboxMode.PAUSE);
            }
        }, () -> this.getMode() == BoomboxMode.PAUSE);
        this.stopButton = this.addBoomboxButton(47, 17, 1, n -> this.insStop());
        this.playButton = this.addBoomboxButton(69, 17, 2, n -> {
            if (!this.getCassetteTape().func_190926_b()) {
                this.insMode(BoomboxMode.PLAY);
            }
        }, () -> this.getMode() == BoomboxMode.PLAY);
        this.loopButton = this.addBoomboxButton(91, 17, 3, n -> {
            BoomboxTileEntity boomboxTile = (BoomboxTileEntity)this.getTileEntity();
            this.insLoop(!boomboxTile.isMusicLoop());
        }, () -> {
            BoomboxTileEntity boomboxTile = (BoomboxTileEntity)this.getTileEntity();
            return boomboxTile.isMusicLoop();
        });
        this.volDownButton = this.addBoomboxButton(119, 17, 4, n -> {
            BoomboxTileEntity boomboxTile = (BoomboxTileEntity)this.getTileEntity();
            if (!boomboxTile.isMusicVolumeMute()) {
                this.insVolumeDown();
            }
        });
        this.volUpButton = this.addBoomboxButton(141, 17, 5, n -> {
            BoomboxTileEntity boomboxTile = (BoomboxTileEntity)this.getTileEntity();
            if (!boomboxTile.isMusicVolumeMute()) {
                this.insVolumeUp();
            }
        });
        this.volMuteButton = this.addBoomboxButton(163, 17, 6, n -> {
            BoomboxTileEntity boomboxTile = (BoomboxTileEntity)this.getTileEntity();
            this.insVolumeMute(!boomboxTile.isMusicVolumeMute());
        }, () -> {
            BoomboxTileEntity boomboxTile = (BoomboxTileEntity)this.getTileEntity();
            return boomboxTile.isMusicVolumeMute();
        });
    }

    private BoomboxButton addBoomboxButton(int x, int y, int btnnum, Button.IPressable pressedAction) {
        return this.addBoomboxButton(x, y, btnnum, pressedAction, () -> false);
    }

    private BoomboxButton addBoomboxButton(int x, int y, int btnnum, Button.IPressable pressedAction, BoomboxButton.IWhetherPresseble whetherpresseble) {
        return (BoomboxButton)this.addWidgetByIKSG((Widget)new BoomboxButton(this.getTexturStartX() + x, this.getTexturStartY() + y, btnnum, n -> {
            if (this.isStateOn()) {
                pressedAction.onPress(n);
            }
        }, whetherpresseble));
    }

    private BoomboxMode getMode() {
        return ((BoomboxTileEntity)this.getTileEntity()).getMode();
    }

    public ResourceLocation getBackGrandTextuer() {
        return BOOMBOX_GUI_TEXTURES;
    }

    protected void drawGuiContainerBackgroundLayerByIKSG(MatrixStack matx, float partTick, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayerByIKSG(matx, partTick, mouseX, mouseY);
        BoomboxTileEntity boomboxTile = (BoomboxTileEntity)this.getTileEntity();
        if (boomboxTile.isOn() && boomboxTile.getMusic() != null) {
            IKSGRenderUtil.guiBindAndBlit((ResourceLocation)BOOMBOX_GUI_TEXTURES, (MatrixStack)matx, (int)(this.getTexturStartX() + 36), (int)(this.getTexturStartY() + 58), (int)154, (int)173, (int)91, (int)3, (int)256, (int)256);
            float cumpp = (float)boomboxTile.getCurrentMusicPlayPosition() / (float)boomboxTile.getMusicDuration();
            IKSGRenderUtil.guiBindAndBlit((ResourceLocation)BOOMBOX_GUI_TEXTURES, (MatrixStack)matx, (int)(this.getTexturStartX() + 36), (int)(this.getTexturStartY() + 58), (int)154, (int)185, (int)((int)(91.0f * cumpp)), (int)3, (int)256, (int)256);
            int zure = this.getMode() == BoomboxMode.PAUSE ? 1 : (this.getMode() == BoomboxMode.NONE ? 2 : 0);
            IKSGRenderUtil.guiBindAndBlit((ResourceLocation)BOOMBOX_GUI_TEXTURES, (MatrixStack)matx, (int)(this.getTexturStartX() + 28), (int)(this.getTexturStartY() + 56), (int)(164 + 7 * zure), (int)165, (int)7, (int)7, (int)256, (int)256);
            IKSGRenderUtil.guiBindAndBlit((ResourceLocation)BOOMBOX_GUI_TEXTURES, (MatrixStack)matx, (int)(this.getTexturStartX() + 128), (int)(this.getTexturStartY() + 55), (int)(154 + (boomboxTile.isMusicLoop() ? 0 : 11)), (int)176, (int)11, (int)8, (int)256, (int)256);
            if (!boomboxTile.isMusicVolumeMute()) {
                IKSGRenderUtil.matrixPush((MatrixStack)matx);
                float fs = 0.75f;
                IKSGRenderUtil.matrixScalf((MatrixStack)matx, (float)fs);
                int fx = this.getTexturStartX() + 126;
                float fy = (float)this.getTexturStartY() + 47.5f;
                IKSGRenderUtil.matrixTranslatef((MatrixStack)matx, (float)((float)fx / fs - (float)fx), (float)(fy / fs - fy), (float)0.0f);
                IKSGRenderUtil.drawString((FontRenderer)this.field_230712_o_, (MatrixStack)matx, (ITextComponent)new StringTextComponent(String.valueOf(boomboxTile.getMusicVolumeN())), (int)fx, (int)((int)fy), (int)2722312);
                IKSGRenderUtil.matrixPop((MatrixStack)matx);
                IKSGRenderUtil.guiBindAndBlit((ResourceLocation)BOOMBOX_GUI_TEXTURES, (MatrixStack)matx, (int)(this.getTexturStartX() + 116), (int)(this.getTexturStartY() + 47), (int)154, (int)165, (int)8, (int)8, (int)256, (int)256);
            } else {
                IKSGRenderUtil.guiBindAndBlit((ResourceLocation)BOOMBOX_GUI_TEXTURES, (MatrixStack)matx, (int)(this.getTexturStartX() + 116), (int)(this.getTexturStartY() + 47), (int)154, (int)188, (int)10, (int)8, (int)256, (int)256);
            }
            if (boomboxTile.isPlayWaiting()) {
                IKSGRenderUtil.drawString((FontRenderer)this.field_230712_o_, (MatrixStack)matx, (ITextComponent)new TranslationTextComponent("boombox.loading"), (int)(this.getTexturStartX() + 29), (int)(this.getTexturStartY() + 47), (int)2722312);
            } else {
                IKSGRenderUtil.drawString((FontRenderer)this.field_230712_o_, (MatrixStack)matx, (ITextComponent)new StringTextComponent(StringUtils.getTimeNotationPercentage(boomboxTile.getCurrentMusicPlayPosition(), boomboxTile.getMusicDuration())), (int)(this.getTexturStartX() + 29), (int)(this.getTexturStartY() + 47), (int)2722312);
            }
        }
    }

    protected void insMode(BoomboxMode mode) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("name", mode.getName());
        this.instruction("Mode", tag);
    }

    protected void insLoop(boolean loop) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("enble", loop);
        this.instruction("Loop", tag);
    }

    protected void insVolumeMute(boolean mute) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("enble", mute);
        this.instruction("VolumeMute", tag);
    }

    protected void insVolumeDown() {
        this.instruction("VolumeDown", new CompoundNBT());
    }

    protected void insVolumeUp() {
        this.instruction("VolumeUp", new CompoundNBT());
    }

    protected void insStop() {
        this.instruction("Stop", new CompoundNBT());
    }

    private ItemStack getCassetteTape() {
        return ((BoomboxTileEntity)this.getTileEntity()).getCassetteTape();
    }

    private static class BoomboxButton
    extends Button {
        private final int buttunNum;
        private final IWhetherPresseble whetherpresseble;

        public BoomboxButton(int x, int y, int buttonNum, Button.IPressable pressedAction, IWhetherPresseble whetherpresseble) {
            super(x, y, 22, 17, (ITextComponent)new TranslationTextComponent("narrator.button.boombox"), pressedAction);
            this.buttunNum = buttonNum;
            this.whetherpresseble = whetherpresseble;
        }

        public void func_230431_b_(MatrixStack matx, int mouseX, int mouseY, float partialTicks) {
            IKSGRenderUtil.guiBindAndBlit((ResourceLocation)BOOMBOX_GUI_TEXTURES, (MatrixStack)matx, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.buttunNum * 22), (int)((this.func_230449_g_() ? 17 : 0) + (this.whetherpresseble.isPresseble() ? 34 : 0) + 165), (int)22, (int)17, (int)256, (int)256);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static interface IWhetherPresseble {
            public boolean isPresseble();
        }
    }
}

