/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.music;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import red.felnull.imp.client.config.ClientConfig;
import red.felnull.imp.client.music.MusicRinger;
import red.felnull.imp.client.music.player.IMusicPlayer;
import red.felnull.imp.client.util.SoundMath;

public class ClientWorldMusicManager {
    private static final Minecraft mc = Minecraft.func_71410_x();
    public final List<IMusicPlayer> screenMusicPlayers = new ArrayList<IMusicPlayer>();
    private static ClientWorldMusicManager INSTANCE;
    private double musicVolume;
    private boolean stereoEnabled;
    private Map<UUID, MusicRinger> mplayers = new HashMap<UUID, MusicRinger>();
    private boolean allStop;

    public static void init() {
        INSTANCE = new ClientWorldMusicManager();
        INSTANCE.setMusicVolume((Double)ClientConfig.MusicVolume.get());
        INSTANCE.setStereoEnabled((Boolean)ClientConfig.StereoEnabled.get());
    }

    public static ClientWorldMusicManager instance() {
        return INSTANCE;
    }

    public void addMusicPlayer(UUID uuid, MusicRinger ringer) {
        this.stopMusicPlayer(uuid);
        this.mplayers.put(uuid, ringer);
    }

    public void stopMusicPlayer(UUID uuid) {
        if (this.mplayers.containsKey(uuid)) {
            this.mplayers.get(uuid).playStop();
            this.mplayers.remove(uuid);
        }
    }

    public void stopAllMusicPlayer() {
        this.allStop = true;
    }

    public void playMusicPlayer(UUID uuid) {
        if (this.mplayers.containsKey(uuid)) {
            this.mplayers.get(uuid).playStart();
        }
    }

    public void playMusicMiddlePlayer(UUID uuid) {
        if (this.mplayers.containsKey(uuid)) {
            this.mplayers.get(uuid).playStartAutoMisalignment();
        }
    }

    public void loop() {
        if (ClientWorldMusicManager.mc.field_71439_g == null && !this.mplayers.isEmpty()) {
            this.stopAllMusicPlayer();
        }
        if (this.allStop) {
            this.allStop = false;
            if (!this.mplayers.isEmpty()) {
                ArrayList<UUID> stopedUUID = new ArrayList<UUID>(new ArrayList<UUID>(this.mplayers.keySet()));
                stopedUUID.forEach(this::stopMusicPlayer);
            }
        }
        this.mplayers.values().forEach(MusicRinger::volumeUpdate);
        for (IMusicPlayer screenMusicPlayer : this.screenMusicPlayers) {
            if (screenMusicPlayer == null) continue;
            float vol = SoundMath.calculateVolume(0.5f, ClientWorldMusicManager.instance().getEventuallyMusicVolume());
            screenMusicPlayer.setVolume(vol);
        }
    }

    public MusicRinger getMusicRinger(UUID uuid) {
        if (this.mplayers.containsKey(uuid)) {
            return this.mplayers.get(uuid);
        }
        return null;
    }

    public double getMusicVolume() {
        return this.musicVolume;
    }

    public float getEventuallyMusicVolume() {
        return (float)this.musicVolume;
    }

    public void setMusicVolume(double musicVolume) {
        this.musicVolume = musicVolume;
    }

    public boolean isStereoEnabled() {
        return this.stereoEnabled;
    }

    public void setStereoEnabled(boolean stereoEnabled) {
        this.stereoEnabled = stereoEnabled;
    }
}

