/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.music;

import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import red.felnull.imp.client.data.MusicSourceClientReferencesType;
import red.felnull.imp.client.music.ClientWorldMusicManager;
import red.felnull.imp.client.music.player.IMusicPlayer;
import red.felnull.imp.client.music.player.URLNotStreamMusicPlayer;
import red.felnull.imp.client.util.SoundMath;
import red.felnull.imp.data.IMPWorldData;
import red.felnull.imp.music.resource.PlayMusic;
import red.felnull.otyacraftengine.api.ResponseSender;

public class MusicRinger {
    private final UUID uuid;
    private final PlayMusic music;
    private Vector3d positionVec;
    private IMusicPlayer musicPlayer;
    private boolean readyPlay;
    private float volume;

    public MusicRinger(UUID uuid, PlayMusic playMusic, Vector3d positionVec) {
        this.uuid = uuid;
        this.music = playMusic;
        this.positionVec = positionVec;
    }

    public Vector3d getPosition() {
        return this.positionVec;
    }

    public void playWait(long startpos) {
        PlayWaitThread pwt = new PlayWaitThread(startpos);
        pwt.start();
    }

    public void playStart() {
        if (this.readyPlay && this.musicPlayer != null) {
            this.musicPlayer.play();
        }
    }

    public void playStartAutoMisalignment() {
        if (this.readyPlay && this.musicPlayer != null) {
            this.musicPlayer.playAutoMisalignment();
        }
    }

    public void playStop() {
        if (this.readyPlay && this.musicPlayer != null) {
            this.musicPlayer.stop();
        }
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public void volumeUpdate() {
        if (this.musicPlayer != null) {
            float rarnge = 30.0f * this.volume;
            float vol = SoundMath.calculateVolume(this.volume / 2.0f, ClientWorldMusicManager.instance().getEventuallyMusicVolume());
            if (this.musicPlayer instanceof URLNotStreamMusicPlayer) {
                if (!((URLNotStreamMusicPlayer)this.musicPlayer).isSpatial()) {
                    vol = SoundMath.calculatePseudoAttenuation(this.getPosition(), rarnge, vol);
                } else {
                    ((URLNotStreamMusicPlayer)this.musicPlayer).setPos(this.getPosition(), rarnge);
                }
            }
            this.musicPlayer.setVolume(vol);
        }
    }

    public IMusicPlayer getMusicPlayer() {
        return this.musicPlayer;
    }

    public class PlayWaitThread
    extends Thread {
        private final long startPos;

        public PlayWaitThread(long pos) {
            this.setName("Play Wait Thread");
            this.startPos = pos;
        }

        @Override
        public void run() {
            if (!MusicRinger.this.readyPlay) {
                try {
                    MusicRinger.this.musicPlayer = MusicSourceClientReferencesType.getMusicPlayer(MusicRinger.this.music);
                    MusicRinger.this.musicPlayer.setVolume(0.0f);
                    MusicRinger.this.musicPlayer.ready(this.startPos);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ResponseSender.sendToServer((ResourceLocation)IMPWorldData.MUSIC_RINGD, (int)0, (String)MusicRinger.this.uuid.toString(), (CompoundNBT)new CompoundNBT());
            MusicRinger.this.readyPlay = true;
        }
    }
}

