/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.music.player;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.Pcm16AudioDataFormat;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import red.felnull.imp.client.music.ClientWorldMusicManager;

public class LavaMusicLoader {
    private static final AudioDataFormat COMMON_PCM_S16_LE_C2 = new Pcm16AudioDataFormat(2, 48000, 960, false);
    private final AudioSourceManager sourceManager;
    private AudioPlayerManager audioPlayerManager;

    public LavaMusicLoader(AudioSourceManager sourceManager) {
        this.sourceManager = sourceManager;
        this.init();
    }

    public void init() {
        this.audioPlayerManager = new DefaultAudioPlayerManager();
        this.audioPlayerManager.setFrameBufferDuration(1000);
        this.audioPlayerManager.setPlayerCleanupThreshold(Long.MAX_VALUE);
        this.audioPlayerManager.getConfiguration().setResamplingQuality(AudioConfiguration.ResamplingQuality.HIGH);
        this.audioPlayerManager.getConfiguration().setOpusEncodingQuality(10);
        this.audioPlayerManager.registerSourceManager(this.sourceManager);
    }

    public AudioPlayerManager getAudioPlayerManager() {
        return this.audioPlayerManager;
    }

    public AudioDataFormat getFormat() {
        return COMMON_PCM_S16_LE_C2;
    }

    public boolean isMono() {
        return !ClientWorldMusicManager.instance().isStereoEnabled();
    }
}

