/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.music.player;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.AudioDataFormatTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.AudioPlayerInputStream;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import net.minecraft.util.math.vector.Vector3d;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.AL11;
import red.felnull.imp.client.music.player.IMusicPlayer;
import red.felnull.imp.client.music.player.LavaMusicLoader;

public class URLNotStreamMusicPlayer
implements IMusicPlayer {
    protected final AudioPlayerManager audioPlayerManager;
    protected final AudioDataFormat dataformat;
    protected final AudioPlayer audioPlayer;
    private final List<Integer> buffers = new ArrayList<Integer>();
    protected final URL url;
    protected boolean trackLoaded;
    private long readyTime;
    protected boolean stereo;
    protected long duration;
    protected Exception exception;
    protected long startPosition;
    protected AudioInputStream stream;
    protected long startTime;
    private int source;
    private boolean intentionallyMono;
    private boolean stopped;
    private float ang;
    private byte[] buffer = new byte[3072];
    private ByteBuffer pcm = BufferUtils.createByteBuffer((int)11025);
    private int trig;
    protected boolean ready;

    public URLNotStreamMusicPlayer(long readyTime, String url, LavaMusicLoader loader) {
        URL url1 = null;
        try {
            if (url != null) {
                url1 = new URL(url);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.url = url1;
        this.readyTime = readyTime;
        this.dataformat = loader.getFormat();
        this.audioPlayerManager = loader.getAudioPlayerManager();
        this.audioPlayerManager.getConfiguration().setOutputFormat(this.dataformat);
        this.audioPlayer = this.audioPlayerManager.createPlayer();
        this.source = AL11.alGenSources();
        this.intentionallyMono = loader.isMono();
        if (!this.intentionallyMono) {
            this.disableAttenuation();
        }
    }

    public boolean isSpatial() {
        return this.intentionallyMono;
    }

    @Override
    public void setSpatial(boolean enable) {
        if (!enable) {
            this.disableAttenuation();
            this.intentionallyMono = false;
        }
    }

    public void setPos(Vector3d pos, float range) {
        AL11.alSource3f((int)this.source, (int)4100, (float)((float)pos.field_72450_a), (float)((float)pos.field_72448_b), (float)((float)pos.field_72449_c));
        this.linearAttenuation(range);
    }

    private void linearAttenuation(float f) {
        AL11.alSourcei((int)this.source, (int)53248, (int)53251);
        AL11.alSourcef((int)this.source, (int)4131, (float)f);
        AL11.alSourcef((int)this.source, (int)4129, (float)1.0f);
        AL11.alSourcef((int)this.source, (int)4128, (float)0.0f);
    }

    private void disableAttenuation() {
        AL11.alSourcei((int)this.source, (int)53248, (int)0);
    }

    @Override
    public void ready(final long position) throws Exception {
        this.startPosition = position;
        this.trackLoaded = false;
        this.audioPlayerManager.loadItem(this.url.toString(), new AudioLoadResultHandler(){

            @Override
            public void trackLoaded(AudioTrack track) {
                track.setPosition(position);
                URLNotStreamMusicPlayer.this.audioPlayer.startTrack(track, false);
                if (!track.getInfo().isStream) {
                    URLNotStreamMusicPlayer.this.duration = track.getDuration();
                }
                URLNotStreamMusicPlayer.this.trackLoaded = true;
            }

            @Override
            public void playlistLoaded(AudioPlaylist playlist) {
                URLNotStreamMusicPlayer.this.exception = new IllegalStateException("ambiguous");
                URLNotStreamMusicPlayer.this.trackLoaded = true;
            }

            @Override
            public void noMatches() {
                URLNotStreamMusicPlayer.this.exception = new IllegalStateException("nomatche");
                URLNotStreamMusicPlayer.this.trackLoaded = true;
            }

            @Override
            public void loadFailed(FriendlyException ex) {
                URLNotStreamMusicPlayer.this.exception = ex;
                URLNotStreamMusicPlayer.this.trackLoaded = true;
            }
        });
        while (!this.trackLoaded) {
            Thread.sleep(20L);
        }
        if (this.exception != null) {
            throw this.exception;
        }
        this.stream = AudioPlayerInputStream.createStream(this.audioPlayer, this.dataformat, this.dataformat.frameDuration(), false);
        this.stereo = AudioDataFormatTools.toAudioFormat(this.dataformat).getChannels() >= 2;
        this.loadOpenAL();
        this.ready = true;
    }

    protected void loadOpenAL() {
        AL11.alSourcef((int)this.source, (int)4099, (float)1.0f);
        AL11.alSourcei((int)this.source, (int)514, (int)0);
        AL11.alSourcei((int)this.source, (int)4103, (int)0);
        AudioFormat format = AudioDataFormatTools.toAudioFormat(this.dataformat);
        for (int i = 0; i < 500; ++i) {
            try {
                if (this.stream == null || this.stream.read(this.buffer) < 0) continue;
                int bff = AL11.alGenBuffers();
                this.ang = this.fillBuffer(this.ang, this.pcm);
                int formatId = this.audioFormatToOpenAl(format);
                AL11.alBufferData((int)bff, (int)formatId, (ByteBuffer)this.getBuffer(this.buffer), (int)((int)format.getSampleRate() * (this.intentionallyMono ? 2 : 1)));
                this.buffers.add(bff);
                AL11.alSourceQueueBuffers((int)this.source, (int)bff);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LoadThread lt = new LoadThread();
        lt.start();
    }

    @Override
    public void play() {
        this.playMisalignment(0L);
    }

    @Override
    public void playMisalignment(long delay) {
        if (!this.ready) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.startPosition += delay;
        if (this.duration == 0L || this.duration >= this.startPosition) {
            float secdelay = (float)delay / 1000.0f;
            AL11.alSourcef((int)this.source, (int)4132, (float)secdelay);
            AL11.alSourcePlay((int)this.source);
        }
    }

    @Override
    public void playAutoMisalignment() {
        long zure = System.currentTimeMillis() - this.readyTime;
        if (this.getMaxMisalignment() > zure) {
            this.playMisalignment(zure);
        }
    }

    @Override
    public void playAndReady(long startMiliSecond) throws Exception {
        this.ready(startMiliSecond);
        this.play();
    }

    @Override
    public void stop() {
        if (this.ready) {
            AL11.alSourceStop((int)this.source);
        }
        this.stopped = true;
        this.startTime = 0L;
        this.startPosition = 0L;
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            this.stream = null;
        }
        this.audioPlayer.destroy();
        if (this.ready) {
            AL11.alSourceStop((int)this.source);
            AL11.alDeleteSources((int)this.source);
            ArrayList<Integer> bffs = new ArrayList<Integer>(this.buffers);
            bffs.forEach(AL10::alDeleteBuffers);
            this.buffers.clear();
        }
    }

    private int getPlayState() {
        if (!this.ready) {
            return 4116;
        }
        return AL11.alGetSourcei((int)this.source, (int)4112);
    }

    @Override
    public boolean isPlaying() {
        return this.getPlayState() == 4114;
    }

    @Override
    public long getMaxMisalignment() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getCureentElapsed() {
        return System.currentTimeMillis() - this.startTime + this.startPosition;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public Object getMusicSource() {
        return this.url;
    }

    @Override
    public void setVolume(float f) {
        AL11.alSourcef((int)this.source, (int)4106, (float)f);
    }

    @Override
    public float getVolume() {
        return AL11.alGetSourcef((int)this.source, (int)4106);
    }

    public float fillBuffer(float ang, ByteBuffer buff) {
        int size = buff.capacity();
        ++this.trig;
        for (int i = 0; i < size; ++i) {
            int source1 = (int)(Math.sin(ang) * 127.0 + 128.0);
            int source2 = 0;
            if (this.trig > 3) {
                source2 = (int)(Math.sin(ang * 3.0f) * 127.0 + 128.0);
            }
            if (this.trig > 4) {
                this.trig = 0;
            }
            buff.put(i, (byte)((source1 + source2) / 2));
            ang += 0.1f;
        }
        return ang;
    }

    public ByteBuffer getBuffer(byte[] array) {
        ByteBuffer audioBuffer2 = BufferUtils.createByteBuffer((int)array.length);
        audioBuffer2.put(array);
        audioBuffer2.flip();
        return audioBuffer2;
    }

    private int audioFormatToOpenAl(AudioFormat audioFormat) {
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        int i = audioFormat.getChannels();
        int j = audioFormat.getSampleSizeInBits();
        if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) || encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            return URLNotStreamMusicPlayer.getOpenALFormat(this.intentionallyMono ? 1 : 2, j);
        }
        throw new IllegalArgumentException("Invalid audio format: " + audioFormat);
    }

    public static int getOpenALFormat(int channel, int bit) {
        if (channel == 1) {
            if (bit == 8) {
                return 4352;
            }
            if (bit == 16) {
                return 4353;
            }
        } else if (channel == 2) {
            if (bit == 8) {
                return 4354;
            }
            if (bit == 16) {
                return 4355;
            }
        }
        return 4353;
    }

    public class LoadThread
    extends Thread {
        public LoadThread() {
            this.setName("LavaPlayer Load Thread");
        }

        @Override
        public void run() {
            try {
                while (URLNotStreamMusicPlayer.this.stream.read(URLNotStreamMusicPlayer.this.buffer) >= 0) {
                    if (URLNotStreamMusicPlayer.this.stopped) {
                        return;
                    }
                    int b = AL11.alGenBuffers();
                    if (URLNotStreamMusicPlayer.this.stopped) {
                        return;
                    }
                    URLNotStreamMusicPlayer.this.ang = URLNotStreamMusicPlayer.this.fillBuffer(URLNotStreamMusicPlayer.this.ang, URLNotStreamMusicPlayer.this.pcm);
                    if (URLNotStreamMusicPlayer.this.stopped) {
                        return;
                    }
                    AudioFormat format = AudioDataFormatTools.toAudioFormat(URLNotStreamMusicPlayer.this.dataformat);
                    if (URLNotStreamMusicPlayer.this.stopped) {
                        return;
                    }
                    int formatId = URLNotStreamMusicPlayer.this.audioFormatToOpenAl(format);
                    if (URLNotStreamMusicPlayer.this.stopped) {
                        return;
                    }
                    AL11.alBufferData((int)b, (int)formatId, (ByteBuffer)URLNotStreamMusicPlayer.this.getBuffer(URLNotStreamMusicPlayer.this.buffer), (int)((int)format.getSampleRate() * (URLNotStreamMusicPlayer.this.intentionallyMono ? 2 : 1)));
                    if (URLNotStreamMusicPlayer.this.stopped) {
                        return;
                    }
                    AL11.alSourceQueueBuffers((int)URLNotStreamMusicPlayer.this.source, (int)b);
                    if (URLNotStreamMusicPlayer.this.stopped) {
                        return;
                    }
                    URLNotStreamMusicPlayer.this.buffers.add(b);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

