/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.music.player;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.AudioDataFormatTools;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.format.AudioPlayerInputStream;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.io.IOException;
import red.felnull.imp.client.music.player.LavaMusicLoader;
import red.felnull.imp.client.music.player.URLNotStreamMusicPlayer;
import red.felnull.imp.client.util.YoutubeUtils;
import red.felnull.imp.libs.com.github.kiulian.downloader.YoutubeException;

public class YoutubeMusicPlayer
extends URLNotStreamMusicPlayer {
    private final LavaMusicLoader youtubeMusicLoader;
    private final String videoID;

    public YoutubeMusicPlayer(long rery, String videoID, LavaMusicLoader loader, LavaMusicLoader youtubeLoader) throws IOException, YoutubeException {
        super(rery, YoutubeUtils.getYoutubeMa4DirectLink(videoID), loader);
        this.videoID = videoID;
        this.youtubeMusicLoader = youtubeLoader;
    }

    @Override
    public void ready(final long position) throws Exception {
        if (this.url != null) {
            super.ready(position);
            if (this.ready) {
                return;
            }
        }
        this.startPosition = position;
        this.trackLoaded = false;
        this.youtubeMusicLoader.getAudioPlayerManager().loadItem(this.videoID, new AudioLoadResultHandler(){

            @Override
            public void trackLoaded(AudioTrack track) {
                track.setPosition(position);
                YoutubeMusicPlayer.this.audioPlayer.startTrack(track, false);
                if (!track.getInfo().isStream) {
                    YoutubeMusicPlayer.this.duration = track.getDuration();
                }
                YoutubeMusicPlayer.this.trackLoaded = true;
            }

            @Override
            public void playlistLoaded(AudioPlaylist playlist) {
                YoutubeMusicPlayer.this.exception = new IllegalStateException("ambiguous");
                YoutubeMusicPlayer.this.trackLoaded = true;
            }

            @Override
            public void noMatches() {
                YoutubeMusicPlayer.this.exception = new IllegalStateException("nomatche");
                YoutubeMusicPlayer.this.trackLoaded = true;
            }

            @Override
            public void loadFailed(FriendlyException ex) {
                YoutubeMusicPlayer.this.exception = ex;
                YoutubeMusicPlayer.this.trackLoaded = true;
            }
        });
        while (!this.trackLoaded) {
            Thread.sleep(20L);
        }
        if (this.exception != null) {
            this.exception = null;
            this.trackLoaded = false;
        } else {
            this.stream = AudioPlayerInputStream.createStream(this.audioPlayer, this.dataformat, this.dataformat.frameDuration(), false);
            this.stereo = AudioDataFormatTools.toAudioFormat(this.dataformat).getChannels() >= 2;
            this.loadOpenAL();
            this.ready = true;
        }
    }

    @Override
    public Object getMusicSource() {
        return this.videoID;
    }
}

