/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import red.felnull.imp.IamMusicPlayer;
import red.felnull.imp.data.IMPWorldData;
import red.felnull.imp.music.resource.PlayImage;
import red.felnull.otyacraftengine.client.util.IKSGRenderUtil;
import red.felnull.otyacraftengine.client.util.IKSGTextureUtil;
import red.felnull.otyacraftengine.util.IKSGColorUtil;
import red.felnull.otyacraftengine.util.IKSGMath;

public class RenderUtil {
    private static final ResourceLocation STRING_PLAYIMAGE = new ResourceLocation("iammusicplayer", "textures/gui/string_playimage.png");
    private static final int maxColor = 0xFFFFFF;

    public static void drwPlayImage(MatrixStack matrix, PlayImage image, int x, int y, int size) {
        RenderUtil.drwPlayImage(matrix, image, x, y, size, 0, 0);
    }

    public static void drwPlayImage(MatrixStack matrix, PlayImage image, byte[] imageData, int x, int y, int size) {
        RenderUtil.drwPlayImage(matrix, image, imageData, x, y, size, 0, 0);
    }

    public static void drwPlayImage(MatrixStack matrix, PlayImage image, int x, int y, int size, int upOver, int downOver) {
        PlayImage.ImageType ityepe = image.getImageType();
        switch (ityepe) {
            case IMGAE: {
                RenderUtil.drwPlayImageImage(matrix, image.getName(), null, x, y, size, upOver, downOver);
                break;
            }
            case STRING: {
                RenderUtil.drwPlayImageString(matrix, image.getName(), x, y, size, upOver, downOver);
                break;
            }
            case PLAYERFACE: {
                RenderUtil.drwPlayImagePlayerFace(matrix, image.getName(), x, y, size, upOver, downOver);
                break;
            }
            case URLIMAGE: {
                RenderUtil.drwPlayImageURLImage(matrix, image.getName(), x, y, size, upOver, downOver);
            }
        }
    }

    public static void drwPlayImage(MatrixStack matrix, PlayImage image, byte[] imageData, int x, int y, int size, int upOver, int downOver) {
        PlayImage.ImageType ityepe = image.getImageType();
        switch (ityepe) {
            case IMGAE: {
                RenderUtil.drwPlayImageImage(matrix, image.getName(), imageData, x, y, size, upOver, downOver);
                break;
            }
            case STRING: {
                RenderUtil.drwPlayImageString(matrix, image.getName(), x, y, size, upOver, downOver);
                break;
            }
            case PLAYERFACE: {
                RenderUtil.drwPlayImagePlayerFace(matrix, image.getName(), x, y, size, upOver, downOver);
                break;
            }
            case URLIMAGE: {
                RenderUtil.drwPlayImageURLImage(matrix, image.getName(), x, y, size, upOver, downOver);
            }
        }
    }

    private static void drwPlayImageString(MatrixStack matrix, String str, int x, int y, int size, int upOver, int downOver) {
        Random r = new Random(IKSGMath.convertStringToInteger((String)str));
        int[] backColor = IKSGColorUtil.convertRGBFromColorCode((int)r.nextInt(0xFFFFFF));
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)((float)backColor[0] / 255.0f), (float)((float)backColor[1] / 255.0f), (float)((float)backColor[2] / 255.0f), (float)1.0f);
        IKSGRenderUtil.guiBindAndBlit((ResourceLocation)STRING_PLAYIMAGE, (MatrixStack)matrix, (int)x, (int)(y + upOver), (int)0, (int)upOver, (int)size, (int)(size - downOver - upOver), (int)size, (int)size);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
        Minecraft mc = IamMusicPlayer.proxy.getMinecraft();
        FontRenderer ft = mc.field_71466_p;
        StringTextComponent comp = new StringTextComponent(str);
        int stWidthSize = ft.func_238414_a_((ITextProperties)comp);
        float baritu = (float)(size - 3) / (float)stWidthSize;
        float f = size;
        ft.getClass();
        float yzure = (f - 9.0f * baritu) / 2.0f;
        float f2 = upOver;
        ft.getClass();
        if (f2 < yzure + 9.0f * baritu) {
            float f3 = downOver;
            ft.getClass();
            if (f3 < yzure + 9.0f * baritu) {
                IKSGRenderUtil.matrixPush((MatrixStack)matrix);
                IKSGRenderUtil.matrixScalf((MatrixStack)matrix, (float)baritu);
                IKSGRenderUtil.drawCenterString((FontRenderer)ft, (MatrixStack)matrix, (ITextComponent)comp, (int)((int)((float)(x + size / 2) / baritu)), (int)((int)(((float)y + yzure) / baritu)), (int)0);
                IKSGRenderUtil.matrixPop((MatrixStack)matrix);
            }
        }
    }

    private static void drwPlayImagePlayerFace(MatrixStack matrix, String str, int x, int y, int size, int upOver, int downOver) {
        IKSGRenderUtil.guiBindAndBlit((ResourceLocation)IKSGTextureUtil.getPlayerSkinTexture((String)str), (MatrixStack)matrix, (int)x, (int)(y + upOver), (int)size, (int)(size + upOver), (int)size, (int)(size - downOver - upOver), (int)(size * 8), (int)(size * 8));
        IKSGRenderUtil.guiBindAndBlit((ResourceLocation)IKSGTextureUtil.getPlayerSkinTexture((String)str), (MatrixStack)matrix, (int)x, (int)(y + upOver), (int)(size * 5), (int)(size + upOver), (int)size, (int)(size - downOver - upOver), (int)(size * 8), (int)(size * 8));
    }

    private static void drwPlayImageImage(MatrixStack matrix, String str, byte[] imageData, int x, int y, int size, int upOver, int downOver) {
        ResourceLocation location = imageData == null ? IKSGTextureUtil.getReceiveTexture((ResourceLocation)IMPWorldData.IMAGE, (String)str) : IKSGTextureUtil.getPictureImageTexture((byte[])imageData);
        int w = IKSGTextureUtil.getWidth((ResourceLocation)location, (int)256);
        int h = IKSGTextureUtil.getHeight((ResourceLocation)location, (int)256);
        int xsize = (int)((float)size * ((float)w / 256.0f));
        int ysize = (int)((float)size * ((float)h / 256.0f));
        int xz = (size - xsize) / 2;
        int yz = (size - ysize) / 2;
        int upOverZure = upOver < yz ? 0 : upOver - yz;
        int downOverZure = downOver < yz ? 0 : downOver - yz;
        IKSGRenderUtil.guiBindAndBlit((ResourceLocation)location, (MatrixStack)matrix, (int)(x + xz), (int)(y + yz + upOverZure), (int)0, (int)upOverZure, (int)xsize, (int)(ysize - downOverZure - upOverZure), (int)xsize, (int)ysize);
    }

    private static void drwPlayImageURLImage(MatrixStack matrix, String url, int x, int y, int size, int upOver, int downOver) {
        ResourceLocation location = url == null ? IKSGTextureUtil.TEXTUER_NOTFINED : (url.isEmpty() ? new ResourceLocation("otyacraftengine", "textures/gui/textuer_not_find.png") : IKSGTextureUtil.getPictureImageURLTexture((String)url));
        float w = IKSGTextureUtil.getWidth((ResourceLocation)location, (int)256);
        float h = IKSGTextureUtil.getHeight((ResourceLocation)location, (int)256);
        int xsize = 0;
        int ysize = 0;
        if (w == h) {
            xsize = size;
            ysize = size;
        } else if (w > h) {
            xsize = size;
            ysize = (int)((float)size * (h / w));
        } else {
            xsize = (int)((float)size * (w / h));
            ysize = size;
        }
        int xz = (size - xsize) / 2;
        int yz = (size - ysize) / 2;
        int upOverZure = upOver < yz ? 0 : upOver - yz;
        int downOverZure = downOver < yz ? 0 : downOver - yz;
        IKSGRenderUtil.guiBindAndBlit((ResourceLocation)location, (MatrixStack)matrix, (int)(x + xz), (int)(y + yz + upOverZure), (int)0, (int)upOverZure, (int)xsize, (int)(ysize - downOverZure - upOverZure), (int)xsize, (int)ysize);
    }
}

