/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.client.util;

import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import dev.felnull.imp.libs.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import red.felnull.imp.client.data.YoutubeData;
import red.felnull.imp.libs.com.github.kiulian.downloader.YoutubeDownloader;
import red.felnull.imp.libs.com.github.kiulian.downloader.downloader.request.RequestVideoInfo;
import red.felnull.imp.libs.com.github.kiulian.downloader.model.videos.VideoInfo;

public class YoutubeUtils {
    private static YoutubeDownloader youtubeDownloader = new YoutubeDownloader();
    public static final Map<String, String> YOUTUBE_THUMBNAILURL = new HashMap<String, String>();

    public static List<AudioTrack> getVideoSearchResults(String searchText) {
        final ArrayList<AudioTrack> list = new ArrayList<AudioTrack>();
        YoutubeData.getAudioPlayerManager().loadItemOrdered((Object)UUID.randomUUID(), "ytsearch:" + searchText, new AudioLoadResultHandler(){

            @Override
            public void trackLoaded(AudioTrack track) {
            }

            @Override
            public void playlistLoaded(AudioPlaylist playlist) {
                list.addAll(playlist.getTracks());
            }

            @Override
            public void noMatches() {
                list.add(null);
            }

            @Override
            public void loadFailed(FriendlyException exception) {
                list.add(null);
            }
        });
        long ft = System.currentTimeMillis();
        while (list.isEmpty()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (System.currentTimeMillis() - ft <= 30000L) continue;
            return new ArrayList<AudioTrack>();
        }
        if (list.get(0) == null) {
            return new ArrayList<AudioTrack>();
        }
        return list;
    }

    public static String getThumbnailURL(String videoID) {
        return String.format("https://i.ytimg.com/vi/%s/hqdefault.jpg", videoID);
    }

    public static boolean isYoutubeURL(String url) {
        return url.contains("youtube") && url.contains("=");
    }

    public static String getYoutubeIDFromURL(String url) {
        String[] ur = url.split("=");
        return ur[ur.length - 1];
    }

    public static String getYoutubeMa4DirectLink(String videoID) {
        VideoInfo video = youtubeDownloader.getVideoInfo(new RequestVideoInfo(videoID)).data();
        if (video != null) {
            return video.bestAudioFormat().url();
        }
        return null;
    }
}

