/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.com.github.kiulian.downloader.cipher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import red.felnull.imp.libs.com.github.kiulian.downloader.YoutubeException;
import red.felnull.imp.libs.com.github.kiulian.downloader.cipher.Cipher;
import red.felnull.imp.libs.com.github.kiulian.downloader.cipher.CipherFactory;
import red.felnull.imp.libs.com.github.kiulian.downloader.cipher.CipherFunction;
import red.felnull.imp.libs.com.github.kiulian.downloader.cipher.DefaultCipher;
import red.felnull.imp.libs.com.github.kiulian.downloader.cipher.JsFunction;
import red.felnull.imp.libs.com.github.kiulian.downloader.cipher.ReverseFunction;
import red.felnull.imp.libs.com.github.kiulian.downloader.cipher.SpliceFunction;
import red.felnull.imp.libs.com.github.kiulian.downloader.cipher.SwapFunctionV1;
import red.felnull.imp.libs.com.github.kiulian.downloader.cipher.SwapFunctionV2;
import red.felnull.imp.libs.com.github.kiulian.downloader.downloader.Downloader;
import red.felnull.imp.libs.com.github.kiulian.downloader.downloader.request.RequestWebpage;
import red.felnull.imp.libs.com.github.kiulian.downloader.downloader.response.Response;

public class CachedCipherFactory
implements CipherFactory {
    private static final String[] INITIAL_FUNCTION_PATTERNS = new String[]{"\\b[cs]\\s*&&\\s*[adf]\\.set\\([^,]+\\s*,\\s*encodeURIComponent\\s*\\(\\s*([a-zA-Z0-9$]+)\\(", "\\b[a-zA-Z0-9]+\\s*&&\\s*[a-zA-Z0-9]+\\.set\\([^,]+\\s*,\\s*encodeURIComponent\\s*\\(\\s*([a-zA-Z0-9$]+)\\(", "(?:\\b|[^a-zA-Z0-9$])([a-zA-Z0-9$]{2})\\s*=\\s*function\\(\\s*a\\s*\\)\\s*\\{\\s*a\\s*=\\s*a\\.split\\(\\s*\"\"\\s*\\)", "([a-zA-Z0-9$]+)\\s*=\\s*function\\(\\s*a\\s*\\)\\s*\\{\\s*a\\s*=\\s*a\\.split\\(\\s*\"\"\\s*\\)", "([\"'])signature\\1\\s*,\\s*([a-zA-Z0-9$]+)\\(", "\\.sig\\|\\|([a-zA-Z0-9$]+)\\(", "yt\\.akamaized\\.net/\\)\\s*\\|\\|\\s*.*?\\s*[cs]\\s*&&\\s*[adf]\\.set\\([^,]+\\s*,\\s*(?:encodeURIComponent\\s*\\()?\\s*()$", "\\b[cs]\\s*&&\\s*[adf]\\.set\\([^,]+\\s*,\\s*([a-zA-Z0-9$]+)\\(", "\\b[a-zA-Z0-9]+\\s*&&\\s*[a-zA-Z0-9]+\\.set\\([^,]+\\s*,\\s*([a-zA-Z0-9$]+)\\(", "\\bc\\s*&&\\s*a\\.set\\([^,]+\\s*,\\s*\\([^)]*\\)\\s*\\(\\s*([a-zA-Z0-9$]+)\\(", "\\bc\\s*&&\\s*[a-zA-Z0-9]+\\.set\\([^,]+\\s*,\\s*\\([^)]*\\)\\s*\\(\\s*([a-zA-Z0-9$]+)\\("};
    private static final String FUNCTION_REVERSE_PATTERN = "\\{\\w\\.reverse\\(\\)\\}";
    private static final String FUNCTION_SPLICE_PATTERN = "\\{\\w\\.splice\\(0,\\w\\)\\}";
    private static final String FUNCTION_SWAP1_PATTERN = "\\{var\\s\\w=\\w\\[0];\\w\\[0]=\\w\\[\\w%\\w.length];\\w\\[\\w]=\\w\\}";
    private static final String FUNCTION_SWAP2_PATTERN = "\\{var\\s\\w=\\w\\[0];\\w\\[0]=\\w\\[\\w%\\w.length];\\w\\[\\w%\\w.length]=\\w\\}";
    private static final String FUNCTION_SWAP3_PATTERN = "function\\(\\w+,\\w+\\)\\{var\\s\\w=\\w\\[0];\\w\\[0]=\\w\\[\\w%\\w.length];\\w\\[\\w%\\w.length]=\\w\\}";
    private static final Pattern[] JS_FUNCTION_PATTERNS = new Pattern[]{Pattern.compile("\\w+\\.(\\w+)\\(\\w,(\\d+)\\)"), Pattern.compile("\\w+\\[(\\\"\\w+\\\")\\]\\(\\w,(\\d+)\\)")};
    private Downloader downloader;
    private List<Pattern> knownInitialFunctionPatterns = new ArrayList<Pattern>();
    private Map<Pattern, CipherFunction> functionsEquivalentMap = new HashMap<Pattern, CipherFunction>();
    private Map<String, Cipher> ciphers = new HashMap<String, Cipher>();

    public CachedCipherFactory(Downloader downloader) {
        this.downloader = downloader;
        for (String pattern : INITIAL_FUNCTION_PATTERNS) {
            this.addInitialFunctionPattern(this.knownInitialFunctionPatterns.size(), pattern);
        }
        this.addFunctionEquivalent(FUNCTION_REVERSE_PATTERN, new ReverseFunction());
        this.addFunctionEquivalent(FUNCTION_SPLICE_PATTERN, new SpliceFunction());
        this.addFunctionEquivalent(FUNCTION_SWAP1_PATTERN, new SwapFunctionV1());
        SwapFunctionV2 swapFunctionV2 = new SwapFunctionV2();
        this.addFunctionEquivalent(FUNCTION_SWAP2_PATTERN, swapFunctionV2);
        this.addFunctionEquivalent(FUNCTION_SWAP3_PATTERN, swapFunctionV2);
    }

    @Override
    public void addInitialFunctionPattern(int priority, String regex) {
        this.knownInitialFunctionPatterns.add(priority, Pattern.compile(regex));
    }

    @Override
    public void addFunctionEquivalent(String regex, CipherFunction function) {
        this.functionsEquivalentMap.put(Pattern.compile(regex), function);
    }

    @Override
    public Cipher createCipher(String jsUrl) throws YoutubeException {
        Cipher cipher = this.ciphers.get(jsUrl);
        if (cipher == null) {
            Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(jsUrl));
            if (!response.ok()) {
                throw new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", jsUrl, response.error().getMessage()));
            }
            String js = response.data();
            List<JsFunction> transformFunctions = this.getTransformFunctions(js);
            String var = transformFunctions.get(0).getVar();
            String[] transformObject = this.getTransformObject(var, js);
            Map<String, CipherFunction> transformFunctionsMap = this.getTransformFunctionsMap(transformObject);
            cipher = new DefaultCipher(transformFunctions, transformFunctionsMap);
            this.ciphers.put(jsUrl, cipher);
        }
        return cipher;
    }

    public void clearCache() {
        this.ciphers.clear();
    }

    private List<JsFunction> getTransformFunctions(String js) throws YoutubeException {
        String name = this.getInitialFunctionName(js).replaceAll("[^$A-Za-z0-9_]", "");
        Pattern pattern = Pattern.compile(Pattern.quote(name) + "=function\\(\\w\\)\\{[a-z=\\.\\(\\\"\\)]*;(.*);(?:.+)\\}");
        Matcher matcher = pattern.matcher(js);
        if (matcher.find()) {
            String[] jsFunctions = matcher.group(1).split(";");
            ArrayList<JsFunction> transformFunctions = new ArrayList<JsFunction>(jsFunctions.length);
            for (String jsFunction : jsFunctions) {
                JsFunction parsedFunction = this.parseFunction(jsFunction);
                transformFunctions.add(parsedFunction);
            }
            return transformFunctions;
        }
        throw new YoutubeException.CipherException("Transformation functions not found");
    }

    private JsFunction parseFunction(String jsFunction) throws YoutubeException {
        for (Pattern jsFunctionPattern : JS_FUNCTION_PATTERNS) {
            String var;
            Matcher matcher = jsFunctionPattern.matcher(jsFunction);
            if (!matcher.find()) continue;
            String[] split = jsFunction.split("\\.");
            if (split.length > 1) {
                var = split[0];
            } else {
                split = jsFunction.split("\\[");
                if (split.length <= 1) continue;
                var = split[0];
            }
            String name = matcher.group(1);
            String argument = matcher.group(2);
            return new JsFunction(var, name, argument);
        }
        throw new YoutubeException.CipherException("Could not parse js function");
    }

    private String getInitialFunctionName(String js) throws YoutubeException {
        for (Pattern pattern : this.knownInitialFunctionPatterns) {
            Matcher matcher = pattern.matcher(js);
            if (!matcher.find()) continue;
            return matcher.group(1);
        }
        throw new YoutubeException.CipherException("Initial function name not found");
    }

    private String[] getTransformObject(String var, String js) throws YoutubeException {
        var = var.replaceAll("[^$A-Za-z0-9_]", "");
        var = Pattern.quote(var);
        Pattern pattern = Pattern.compile(String.format("var %s=\\{(.*?)\\};", var), 32);
        Matcher matcher = pattern.matcher(js);
        if (matcher.find()) {
            return matcher.group(1).replaceAll("\n", " ").split(", ");
        }
        throw new YoutubeException.CipherException("Transform object not found");
    }

    private Map<String, CipherFunction> getTransformFunctionsMap(String[] transformObject) throws YoutubeException {
        HashMap<String, CipherFunction> mapper = new HashMap<String, CipherFunction>();
        for (String obj : transformObject) {
            String[] split = obj.split(":", 2);
            String name = split[0];
            String jsFunction = split[1];
            CipherFunction function = this.mapFunction(jsFunction);
            mapper.put(name, function);
        }
        return mapper;
    }

    private CipherFunction mapFunction(String jsFunction) throws YoutubeException {
        for (Map.Entry<Pattern, CipherFunction> entry : this.functionsEquivalentMap.entrySet()) {
            Matcher matcher = entry.getKey().matcher(jsFunction);
            if (!matcher.find()) continue;
            return entry.getValue();
        }
        throw new YoutubeException.CipherException("Map function not found");
    }
}

