/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.com.sedmelluq.lava.common.natives.architecture;

import java.util.Optional;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.NativeLibraryProperties;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.architecture.ArchitectureType;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.architecture.DefaultArchitectureTypes;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.architecture.DefaultOperatingSystemTypes;
import red.felnull.imp.libs.com.sedmelluq.lava.common.natives.architecture.OperatingSystemType;

public class SystemType {
    public final ArchitectureType architectureType;
    public final OperatingSystemType osType;

    public SystemType(ArchitectureType architectureType, OperatingSystemType osType) {
        this.architectureType = architectureType;
        this.osType = osType;
    }

    public String formatSystemName() {
        if (this.osType.identifier() != null) {
            if (this.osType == DefaultOperatingSystemTypes.DARWIN) {
                return this.osType.identifier();
            }
            return this.osType.identifier() + "-" + this.architectureType.identifier();
        }
        return this.architectureType.identifier();
    }

    public String formatLibraryName(String libraryName) {
        return this.osType.libraryFilePrefix() + libraryName + this.osType.libraryFileSuffix();
    }

    public static SystemType detect(NativeLibraryProperties properties) {
        String systemName = properties.getSystemName();
        if (systemName != null) {
            return new SystemType(() -> systemName, new UnknownOperatingSystem(Optional.ofNullable(properties.getLibraryFileNamePrefix()).orElse("lib"), Optional.ofNullable(properties.getLibraryFileNameSuffix()).orElse(".so")));
        }
        OperatingSystemType osType = DefaultOperatingSystemTypes.detect();
        String explicitArchitecture = properties.getArchitectureName();
        ArchitectureType architectureType = explicitArchitecture != null ? () -> explicitArchitecture : DefaultArchitectureTypes.detect();
        return new SystemType(architectureType, osType);
    }

    private static class UnknownOperatingSystem
    implements OperatingSystemType {
        private final String libraryFilePrefix;
        private final String libraryFileSuffix;

        private UnknownOperatingSystem(String libraryFilePrefix, String libraryFileSuffix) {
            this.libraryFilePrefix = libraryFilePrefix;
            this.libraryFileSuffix = libraryFileSuffix;
        }

        @Override
        public String identifier() {
            return null;
        }

        @Override
        public String libraryFilePrefix() {
            return this.libraryFilePrefix;
        }

        @Override
        public String libraryFileSuffix() {
            return this.libraryFileSuffix;
        }
    }
}

