/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.dev.felnull.fnjl.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.Function;

public class ProgressWriter {
    private final InputStream stream;
    private final long length;
    private final Function<WriteData, IOException> writer;
    private final Consumer<WriteProgressListener> progress;

    public ProgressWriter(InputStream stream, long length, Function<WriteData, IOException> writer, Consumer<WriteProgressListener> progress) {
        this.stream = stream;
        this.length = length;
        this.writer = writer;
        this.progress = progress;
    }

    public void start() throws IOException {
        int x;
        BufferedInputStream bstream = new BufferedInputStream(this.stream);
        final byte[] data = new byte[1024];
        long ct = 0L;
        while ((x = bstream.read(data, 0, 1024)) >= 0) {
            final int finalX = x;
            IOException ex = this.writer.apply(new WriteData(){

                @Override
                public byte[] getBytes() {
                    return data;
                }

                @Override
                public long getReadSize() {
                    return finalX;
                }
            });
            final long finalCt = ct += (long)x;
            this.progress.accept(new WriteProgressListener(){

                @Override
                public long getLength() {
                    return ProgressWriter.this.length;
                }

                @Override
                public long getWrittenLength() {
                    return finalCt;
                }
            });
            if (ex == null) continue;
            throw ex;
        }
    }

    public static interface WriteProgressListener {
        public long getLength();

        public long getWrittenLength();

        default public double getProgress() {
            return (float)this.getWrittenLength() / (float)this.getLength();
        }
    }

    public static interface WriteData {
        public byte[] getBytes();

        public long getReadSize();
    }
}

