/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.dev.felnull.fnjl.math;

import java.util.Objects;
import red.felnull.imp.libs.dev.felnull.fnjl.math.FNVec2d;
import red.felnull.imp.libs.dev.felnull.fnjl.math.FNVec2f;

public class FNVec2i {
    private int x;
    private int y;

    public FNVec2i(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public double distance(FNVec2i vec) {
        return Math.sqrt(Math.pow(this.x - vec.getX(), 2.0) + Math.pow(this.y - vec.getY(), 2.0));
    }

    public FNVec2i add(FNVec2i vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        return this;
    }

    public FNVec2i sub(FNVec2i vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FNVec2i fnVec2i = (FNVec2i)o;
        return this.x == fnVec2i.x && this.y == fnVec2i.y;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "FNVec2i{x=" + this.x + ", y=" + this.y + '}';
    }

    public FNVec2f convertFloat() {
        return new FNVec2f(this.x, this.y);
    }

    public FNVec2d convertDouble() {
        return new FNVec2d(this.x, this.y);
    }
}

