/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.dev.felnull.fnjl.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;

public class FNRuntimeUtil {
    private static final Map<Runnable, Long> lastTimes = new HashMap<Runnable, Long>();
    private static final List<Timer> timers = new ArrayList<Timer>();

    public static void oneDayClockTimer(int hours, int minutes, Runnable runnable) {
        FNRuntimeUtil.oneDayClockTimer(hours, minutes, runnable, false);
    }

    public static void oneDayClockTimer(final int hours, final int minutes, final Runnable runnable, boolean daemon) {
        Timer timer = new Timer(daemon);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Date date;
                long lastTime = 0L;
                if (lastTimes.containsKey(runnable)) {
                    lastTime = (Long)lastTimes.get(runnable);
                }
                if (System.currentTimeMillis() - lastTime > 3600000L && (date = new Date()).getHours() == hours && date.getMinutes() == minutes) {
                    runnable.run();
                    lastTimes.put(runnable, System.currentTimeMillis());
                }
            }
        };
        timer.schedule(task, 0L, 1000L);
        timers.add(timer);
    }

    public static CompletableFuture<Void> multipleRun(Runnable runnable, Runnable ... runnables) {
        return FNRuntimeUtil.multipleRun(null, -1, runnable, runnables);
    }

    public static CompletableFuture<Void> multipleRun(String threadName, Runnable runnable, Runnable ... runnables) {
        return FNRuntimeUtil.multipleRun(threadName, -1, runnable, runnables);
    }

    public static CompletableFuture<Void> multipleRun(int max, Runnable runnable, Runnable ... runnables) {
        return FNRuntimeUtil.multipleRun(null, max, runnable, runnables);
    }

    public static CompletableFuture<Void> multipleRun(String threadName, int max, Runnable runnable, Runnable ... runnables) {
        if (max <= 0) {
            max = 1 + runnables.length;
        }
        int mx = max;
        return CompletableFuture.runAsync(() -> {
            Object obj = new Object();
            AtomicInteger fin = new AtomicInteger();
            AtomicInteger maxFin = new AtomicInteger();
            ArrayList<Thread> runners = new ArrayList<Thread>();
            runners.add(new Thread(() -> {
                runnable.run();
                Object object = obj;
                synchronized (object) {
                    fin.getAndIncrement();
                    if (fin.get() >= maxFin.get()) {
                        obj.notifyAll();
                    }
                }
            }));
            for (Runnable run : runnables) {
                runners.add(new Thread(() -> {
                    run.run();
                    Object object = obj;
                    synchronized (object) {
                        fin.getAndIncrement();
                        if (fin.get() >= maxFin.get()) {
                            obj.notifyAll();
                        }
                    }
                }));
            }
            if (threadName != null) {
                for (int i = 0; i < runners.size(); ++i) {
                    ((Thread)runners.get(i)).setName(threadName + "-" + i);
                }
            }
            do {
                ArrayList<Thread> rms = new ArrayList<Thread>();
                int ct = 0;
                for (Thread runner : runners) {
                    rms.add(runner);
                    if (++ct < mx) continue;
                    break;
                }
                maxFin.set(ct);
                rms.forEach(Thread::start);
                runners.removeAll(rms);
                Object object = obj;
                synchronized (object) {
                    try {
                        if (fin.get() < maxFin.get()) {
                            obj.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                fin.set(0);
            } while (!runners.isEmpty());
        });
    }

    public static void kill() {
        for (Timer timer : timers) {
            timer.cancel();
            timer.purge();
        }
        timers.clear();
        lastTimes.clear();
    }
}

