/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.org.apache.http.impl.conn;

import java.net.InetAddress;
import red.felnull.imp.libs.org.apache.http.HttpException;
import red.felnull.imp.libs.org.apache.http.HttpHost;
import red.felnull.imp.libs.org.apache.http.HttpRequest;
import red.felnull.imp.libs.org.apache.http.ProtocolException;
import red.felnull.imp.libs.org.apache.http.annotation.Contract;
import red.felnull.imp.libs.org.apache.http.annotation.ThreadingBehavior;
import red.felnull.imp.libs.org.apache.http.client.config.RequestConfig;
import red.felnull.imp.libs.org.apache.http.client.protocol.HttpClientContext;
import red.felnull.imp.libs.org.apache.http.conn.SchemePortResolver;
import red.felnull.imp.libs.org.apache.http.conn.UnsupportedSchemeException;
import red.felnull.imp.libs.org.apache.http.conn.routing.HttpRoute;
import red.felnull.imp.libs.org.apache.http.conn.routing.HttpRoutePlanner;
import red.felnull.imp.libs.org.apache.http.impl.conn.DefaultSchemePortResolver;
import red.felnull.imp.libs.org.apache.http.protocol.HttpContext;
import red.felnull.imp.libs.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultRoutePlanner
implements HttpRoutePlanner {
    private final SchemePortResolver schemePortResolver;

    public DefaultRoutePlanner(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    @Override
    public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost target;
        Args.notNull(request, "Request");
        if (host == null) {
            throw new ProtocolException("Target host is not specified");
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig config = clientContext.getRequestConfig();
        InetAddress local = config.getLocalAddress();
        HttpHost proxy = config.getProxy();
        if (proxy == null) {
            proxy = this.determineProxy(host, request, context);
        }
        if (host.getPort() <= 0) {
            try {
                target = new HttpHost(host.getHostName(), this.schemePortResolver.resolve(host), host.getSchemeName());
            }
            catch (UnsupportedSchemeException ex) {
                throw new HttpException(ex.getMessage());
            }
        } else {
            target = host;
        }
        boolean secure = target.getSchemeName().equalsIgnoreCase("https");
        return proxy == null ? new HttpRoute(target, local, secure) : new HttpRoute(target, local, proxy, secure);
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        return null;
    }
}

