/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.libs.org.apache.http.protocol;

import java.io.IOException;
import red.felnull.imp.libs.org.apache.http.HttpException;
import red.felnull.imp.libs.org.apache.http.HttpResponse;
import red.felnull.imp.libs.org.apache.http.HttpResponseInterceptor;
import red.felnull.imp.libs.org.apache.http.annotation.Contract;
import red.felnull.imp.libs.org.apache.http.annotation.ThreadingBehavior;
import red.felnull.imp.libs.org.apache.http.protocol.HttpContext;
import red.felnull.imp.libs.org.apache.http.protocol.HttpDateGenerator;
import red.felnull.imp.libs.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

