/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.music;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.PacketDistributor;
import red.felnull.imp.data.IMPWorldData;
import red.felnull.imp.music.IWorldRingWhether;
import red.felnull.imp.music.resource.PlayMusic;
import red.felnull.imp.packet.MusicRingMessage;
import red.felnull.imp.packet.MusicRingUpdateMessage;
import red.felnull.imp.packet.PacketHandler;
import red.felnull.otyacraftengine.api.ResponseSender;
import red.felnull.otyacraftengine.util.IKSGPlayerUtil;
import red.felnull.otyacraftengine.util.IKSGServerUtil;

public class WorldMusicRinger {
    private final List<UUID> playingPlayers = new ArrayList<UUID>();
    private final List<UUID> loadingPlayers = new ArrayList<UUID>();
    private final List<UUID> loadWaitingPlayers = new ArrayList<UUID>();
    private final List<UUID> waitingMiddlePlayers = new ArrayList<UUID>();
    private final List<UUID> regularConfirmationPlayers = new ArrayList<UUID>();
    private final UUID uuid;
    private final ResourceLocation dimension;
    private final PlayMusic playMusic;
    private final IWorldRingWhether whether;
    private long lastUpdateTime;
    private long ringStartTime;
    private long ringStartElapsedTime;
    private boolean playWaitingPrev;
    private boolean playWaiting;
    private long waitTime;
    private boolean playing;
    private boolean ringin;

    public WorldMusicRinger(UUID uuid, ResourceLocation dimension, PlayMusic playMusic, IWorldRingWhether whether) {
        this.uuid = uuid;
        this.dimension = dimension;
        this.playMusic = playMusic;
        this.whether = whether;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public void play() {
        if (this.whether.canMusicPlay()) {
            this.whether.musicPlayed();
        }
        this.ringStartElapsedTime = this.getCurrentMusicPlayPosition();
        if (IKSGServerUtil.getOnlinePlayers().stream().anyMatch(this::canListen)) {
            this.playWaitingPrev = true;
            this.playWaiting = true;
        } else {
            this.playing = true;
            this.ringin = true;
            this.ringStartTime = System.currentTimeMillis();
        }
    }

    public void stop() {
        this.pause();
        this.whether.musicStoped();
    }

    public long getCurrentMusicPlayPosition() {
        return this.whether.getCurrentMusicPlayPosition();
    }

    public void pause() {
        this.playing = false;
        this.ringin = false;
        this.playWaitingPrev = false;
        this.playWaiting = false;
        this.playingPlayers.stream().filter(n -> IKSGServerUtil.isOnlinePlayer((String)n.toString())).forEach(n -> ResponseSender.sendToClient((String)n.toString(), (MinecraftServer)IKSGServerUtil.getMinecraftServer(), (ResourceLocation)IMPWorldData.WORLD_RINGD, (int)1, (String)this.uuid.toString(), (CompoundNBT)new CompoundNBT()));
        this.playingPlayers.clear();
        this.loadingPlayers.clear();
        this.loadWaitingPlayers.clear();
        this.waitingMiddlePlayers.clear();
        this.regularConfirmationPlayers.clear();
    }

    public void playerPause(UUID plyaerUUID) {
        ResponseSender.sendToClient((String)plyaerUUID.toString(), (MinecraftServer)IKSGServerUtil.getMinecraftServer(), (ResourceLocation)IMPWorldData.WORLD_RINGD, (int)1, (String)this.uuid.toString(), (CompoundNBT)new CompoundNBT());
        this.playingPlayers.remove(plyaerUUID);
        this.loadingPlayers.remove(plyaerUUID);
        this.loadWaitingPlayers.remove(plyaerUUID);
        this.waitingMiddlePlayers.remove(plyaerUUID);
        this.regularConfirmationPlayers.remove(plyaerUUID);
    }

    public boolean isRelatedPlayer(UUID playerUUID) {
        boolean flag1 = this.playingPlayers.contains(playerUUID);
        boolean flag2 = this.loadingPlayers.contains(playerUUID);
        boolean flag3 = this.loadWaitingPlayers.contains(playerUUID);
        boolean flag4 = this.waitingMiddlePlayers.contains(playerUUID);
        boolean flag5 = this.regularConfirmationPlayers.contains(playerUUID);
        return flag1 || flag2 || flag3 || flag4 || flag5;
    }

    public boolean tick() {
        if (this.playMusic == null) {
            this.stop();
        }
        if (!this.whether.canMusicPlay() || this.playMusic == null) {
            return true;
        }
        this.waitTime = this.playWaiting ? (this.waitTime += System.currentTimeMillis() - this.lastUpdateTime) : 0L;
        Stream<ServerPlayerEntity> listenPlayers = IKSGServerUtil.getOnlinePlayers().stream().filter(this::canListen);
        if (this.playWaiting && this.playWaitingPrev) {
            listenPlayers.filter(n -> !this.loadingPlayers.contains(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n))) && !this.loadWaitingPlayers.contains(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n))) && !this.playingPlayers.contains(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n))) && !this.waitingMiddlePlayers.contains(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n)))).forEach(n -> {
                this.loadingPlayers.add(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n)));
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> n), (Object)new MusicRingMessage(this.uuid, this.getMusicPos(), this.getPlayMusic(), this.getCurrentMusicPlayPosition()));
            });
            this.playWaitingPrev = false;
        } else if (this.playWaiting && this.loadingPlayers.isEmpty()) {
            this.loadWaitingPlayers.stream().filter(n -> this.canListen(IKSGPlayerUtil.getPlayerByUUID((String)n.toString()))).forEach(n -> ResponseSender.sendToClient((String)n.toString(), (MinecraftServer)IKSGServerUtil.getMinecraftServer(), (ResourceLocation)IMPWorldData.WORLD_RINGD, (int)0, (String)this.uuid.toString(), (CompoundNBT)new CompoundNBT()));
            this.playingPlayers.addAll(this.loadWaitingPlayers);
            this.playWaiting = false;
            this.ringin = true;
            this.ringStartTime = System.currentTimeMillis();
        }
        if (this.ringin) {
            long cur = this.ringStartElapsedTime + System.currentTimeMillis() - this.ringStartTime;
            if (cur >= this.playMusic.getLengthInMilliseconds()) {
                if (this.whether.isMusicLoop()) {
                    this.pause();
                    this.whether.setCurrentMusicPlayPosition(0L);
                    this.play();
                } else {
                    this.stop();
                    this.whether.setCurrentMusicPlayPosition(0L);
                }
            } else {
                this.whether.setCurrentMusicPlayPosition(cur);
            }
            IKSGServerUtil.getOnlinePlayers().stream().filter(this::canListen).forEach(n -> {
                if (!this.playingPlayers.contains(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n))) && !this.waitingMiddlePlayers.contains(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n)))) {
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> n), (Object)new MusicRingMessage(this.uuid, this.getMusicPos(), this.getPlayMusic(), this.getCurrentMusicPlayPosition()));
                    this.waitingMiddlePlayers.add(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n)));
                }
                if (this.playingPlayers.contains(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n)))) {
                    PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> n), (Object)new MusicRingUpdateMessage(this.uuid, this.getMusicPos(), this.getMusicVolume()));
                }
            });
            IKSGServerUtil.getOnlinePlayers().stream().filter(n -> this.isRelatedPlayer(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n)))).filter(n -> !this.canListen((ServerPlayerEntity)n)).forEach(n -> this.playerPause(UUID.fromString(IKSGPlayerUtil.getUUID((PlayerEntity)n))));
        }
        this.lastUpdateTime = System.currentTimeMillis();
        return false;
    }

    public boolean isPlayWaiting() {
        return this.playWaiting;
    }

    public PlayMusic getPlayMusic() {
        return this.playMusic;
    }

    public Vector3d getMusicPos() {
        return this.whether.getMusicPos();
    }

    public float getMusicVolume() {
        return this.whether.getMusicVolume();
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public float getListenRange() {
        return 30.0f * this.getMusicVolume();
    }

    private boolean canListen(ServerPlayerEntity player) {
        return player.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)this.getDimension()) && Math.sqrt(player.func_195048_a(this.getMusicPos())) <= (double)(this.getListenRange() + 30.0f);
    }

    public void musicLoadingFinish(UUID playerUUID) {
        if (this.loadingPlayers.contains(playerUUID)) {
            this.loadingPlayers.remove(playerUUID);
            this.loadWaitingPlayers.add(playerUUID);
        } else if (this.canListen(IKSGPlayerUtil.getPlayerByUUID((String)playerUUID.toString()))) {
            ResponseSender.sendToClient((String)playerUUID.toString(), (MinecraftServer)IKSGServerUtil.getMinecraftServer(), (ResourceLocation)IMPWorldData.WORLD_RINGD, (int)2, (String)this.uuid.toString(), (CompoundNBT)new CompoundNBT());
            this.playingPlayers.add(playerUUID);
        }
    }

    public void musicLoadingNotFinishRegularConfirmation(UUID playerUUID) {
        if (this.loadingPlayers.contains(playerUUID)) {
            this.loadingPlayers.remove(playerUUID);
        }
        this.regularConfirmationPlayers.add(playerUUID);
    }
}

