/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.music.resource;

import java.util.Objects;
import net.minecraft.nbt.CompoundNBT;
import red.felnull.otyacraftengine.data.INBTReadWriter;

public class PlayImage
implements INBTReadWriter {
    public static final PlayImage EMPTY = new PlayImage(ImageType.STRING, "empty");
    private ImageType imageType;
    private String name;

    public PlayImage(ImageType type, String str) {
        this.imageType = type;
        this.name = str;
    }

    public PlayImage(CompoundNBT tag) {
        this.read(tag);
    }

    public void read(CompoundNBT tag) {
        this.imageType = ImageType.getImageTypeByName(tag.func_74779_i("ImageType"));
        this.name = tag.func_74779_i("Name");
    }

    public CompoundNBT write(CompoundNBT tag) {
        tag.func_74778_a("ImageType", this.imageType.getNmae());
        tag.func_74778_a("Name", this.name);
        return tag;
    }

    public ImageType getImageType() {
        return this.imageType;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlayImage playImage = (PlayImage)o;
        return this.imageType == playImage.imageType && Objects.equals(this.name, playImage.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.imageType, this.name});
    }

    public static enum ImageType {
        IMGAE("imgae"),
        STRING("string"),
        PLAYERFACE("playerface"),
        URLIMAGE("urlimage");

        private final String nmae;

        private ImageType(String name) {
            this.nmae = name;
        }

        public String getNmae() {
            return this.nmae;
        }

        public static ImageType getImageTypeByName(String name) {
            for (ImageType it : ImageType.values()) {
                if (!it.getNmae().equals(name)) continue;
                return it;
            }
            return STRING;
        }
    }
}

