/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.music.resource;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import red.felnull.imp.IamMusicPlayer;
import red.felnull.imp.data.IMPWorldData;
import red.felnull.imp.music.resource.PlayImage;
import red.felnull.imp.music.resource.PlayList;
import red.felnull.imp.music.resource.PlayLocation;
import red.felnull.otyacraftengine.data.INBTReadWriter;
import red.felnull.otyacraftengine.data.WorldDataManager;
import red.felnull.otyacraftengine.util.IKSGNBTUtil;

public class PlayMusic
implements INBTReadWriter {
    public static final PlayMusic EMPTY = new PlayMusic("de61ebfc-0451-483e-ba22-8f915214864e", "empty", PlayImage.EMPTY, "", "", "", PlayLocation.EMPTY, "", "", "", "", 0L);
    private final String UUID;
    private String name;
    private String createPlayerName;
    private String createPlayerUUID;
    private String timeStamp;
    private PlayLocation musicLocation;
    private String artist;
    private String album;
    private String year;
    private String genre;
    private long lengthInMilliseconds;
    private PlayImage image;

    public PlayMusic(String UUID2, String name, PlayImage image, String createPlayerName, String createPlayerUUID, String timeStamp, PlayLocation musicLocation, String artist, String album, String year, String genre, long lengthInMilliseconds) {
        this.UUID = UUID2;
        this.name = name;
        this.image = image;
        this.createPlayerName = createPlayerName;
        this.createPlayerUUID = createPlayerUUID;
        this.timeStamp = timeStamp;
        this.musicLocation = musicLocation;
        this.artist = artist;
        this.album = album;
        this.year = year;
        this.genre = genre;
        this.lengthInMilliseconds = lengthInMilliseconds;
    }

    public PlayMusic(String UUID2, CompoundNBT tag) {
        this.UUID = UUID2;
        this.read(tag);
    }

    public void read(CompoundNBT tag) {
        this.name = tag.func_74779_i("Name");
        this.image = new PlayImage(tag.func_74775_l("Image"));
        this.createPlayerName = tag.func_74779_i("CreatePlayerName");
        this.createPlayerUUID = tag.func_74779_i("CreatePlayerUUID");
        this.timeStamp = tag.func_74779_i("TimeStamp");
        this.musicLocation = new PlayLocation(tag.func_74775_l("MusicLocation"));
        this.artist = tag.func_74779_i("Artist");
        this.album = tag.func_74779_i("Album");
        this.year = tag.func_74779_i("Year");
        this.genre = tag.func_74779_i("Genre");
        this.lengthInMilliseconds = tag.func_74763_f("LengthInMilliseconds");
    }

    public CompoundNBT write(CompoundNBT tag) {
        tag.func_74778_a("Name", this.name);
        tag.func_218657_a("Image", (INBT)this.image.write(new CompoundNBT()));
        tag.func_74778_a("CreatePlayerName", this.createPlayerName);
        tag.func_74778_a("CreatePlayerUUID", this.createPlayerUUID);
        tag.func_74778_a("TimeStamp", this.timeStamp);
        tag.func_218657_a("MusicLocation", (INBT)this.musicLocation.write(new CompoundNBT()));
        tag.func_74778_a("Artist", this.artist);
        tag.func_74778_a("Album", this.album);
        tag.func_74778_a("Year", this.year);
        tag.func_74778_a("Genre", this.genre);
        tag.func_74772_a("LengthInMilliseconds", this.lengthInMilliseconds);
        return tag;
    }

    public String getUUID() {
        return this.UUID;
    }

    public String getName() {
        return this.name;
    }

    public PlayImage getImage() {
        return this.image;
    }

    public String getCreatePlayerUUID() {
        return this.createPlayerUUID;
    }

    public String getCreatePlayerName() {
        return this.createPlayerName;
    }

    public String getTimeStamp() {
        return this.timeStamp;
    }

    public PlayLocation getMusicLocation() {
        return this.musicLocation;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getYear() {
        return this.year;
    }

    public String getGenre() {
        return this.genre;
    }

    public long getLengthInMilliseconds() {
        return this.lengthInMilliseconds;
    }

    public void addPlayMusicToPlayList(PlayList plst) {
        PlayMusic.addPlayMusicToPlayList(plst, this);
    }

    public static void addPlayMusic(PlayMusic music) {
        WorldDataManager.instance().getWorldData(IMPWorldData.PLAYMUSIC_DATA).func_74775_l("playmusics").func_218657_a(music.getUUID(), (INBT)music.write(new CompoundNBT()));
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlbum(String album) {
        this.album = album;
    }

    public void setArtist(String artist) {
        this.artist = artist;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public void setImage(PlayImage image) {
        this.image = image;
    }

    public static void addPlayMusicToPlayList(PlayList plst, PlayMusic pmusci) {
        IamMusicPlayer.LOGGER.info(pmusci.getCreatePlayerName() + " Add PlayMusic(" + pmusci.getName() + ") to PlayList(" + plst.getName() + ")");
        String listuuid = plst.getUUID();
        CompoundNBT pmtag = WorldDataManager.instance().getWorldData(IMPWorldData.PLAYMUSIC_DATA).func_74775_l("playlists");
        CompoundNBT pmutag = null;
        pmutag = !pmtag.func_74764_b(listuuid) ? new CompoundNBT() : pmtag.func_74775_l(listuuid);
        pmutag.func_218657_a("playmusic", (INBT)IKSGNBTUtil.addStringList((CompoundNBT)pmutag.func_74775_l("playmusic"), (String)pmusci.getUUID()));
        pmtag.func_218657_a(listuuid, (INBT)pmutag);
    }

    public static PlayMusic getPlayMusicByUUID(String uuid) {
        CompoundNBT pmtag = WorldDataManager.instance().getWorldData(IMPWorldData.PLAYMUSIC_DATA).func_74775_l("playmusics");
        if (!pmtag.func_74764_b(uuid)) {
            return EMPTY;
        }
        return new PlayMusic(uuid, pmtag.func_74775_l(uuid));
    }

    public static List<PlayMusic> getIncludedPlayMusics(PlayList plist) {
        String uuid;
        ArrayList<PlayMusic> list = new ArrayList<PlayMusic>();
        CompoundNBT pltag = WorldDataManager.instance().getWorldData(IMPWorldData.PLAYMUSIC_DATA).func_74775_l("playlists");
        if (!pltag.func_74764_b(uuid = plist.getUUID())) {
            return list;
        }
        List sts = IKSGNBTUtil.readStringList((CompoundNBT)pltag.func_74775_l(uuid).func_74775_l("playmusic"));
        sts.forEach(n -> list.add(PlayMusic.getPlayMusicByUUID(n)));
        return list;
    }

    public static void setPlayMusic(PlayMusic plst) {
        PlayMusic.removePlayMusic(plst, false);
        PlayMusic.addPlayMusic(plst);
    }

    public static void removePlayMusic(PlayMusic plst, boolean rejoin) {
        if (rejoin) {
            CompoundNBT plutag = WorldDataManager.instance().getWorldData(IMPWorldData.PLAYMUSIC_DATA).func_74775_l("playlists");
            ArrayList stars = new ArrayList(plutag.func_150296_c());
            stars.forEach(n -> {
                CompoundNBT tag = plutag.func_74775_l(n).func_74775_l("playmusic");
                for (int i = 0; i < tag.func_150296_c().size(); ++i) {
                    if (!tag.func_74779_i(String.valueOf(i)).equals(plst.getUUID())) continue;
                    tag.func_82580_o(String.valueOf(i));
                }
            });
        }
        WorldDataManager.instance().getWorldData(IMPWorldData.PLAYMUSIC_DATA).func_74775_l("playmusics").func_82580_o(plst.getUUID());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof PlayMusic && ((PlayMusic)obj).getUUID().equals(this.getUUID());
    }
}

