/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.tileentity;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import red.felnull.imp.block.BoomboxBlock;
import red.felnull.imp.block.IMPAbstractEquipmentBlock;
import red.felnull.imp.block.propertie.BoomboxMode;
import red.felnull.imp.container.BoomboxContainer;
import red.felnull.imp.music.resource.PlayMusic;
import red.felnull.imp.tileentity.IMPAbstractEquipmentTileEntity;
import red.felnull.imp.tileentity.IMPTileEntityTypes;
import red.felnull.imp.tileentity.IMusicPlayerTileEntity;
import red.felnull.imp.util.ItemHelper;

public class BoomboxTileEntity
extends IMPAbstractEquipmentTileEntity
implements IMusicPlayerTileEntity {
    private UUID mPlayerUUID = UUID.randomUUID();
    private long currentPlayPos;
    private boolean playWaiting;
    private boolean musicLoop;
    private int musicVolume = 100;
    private boolean musicVolumeMute;
    private boolean isRedStoneOn;

    public BoomboxTileEntity() {
        super(IMPTileEntityTypes.BOOMBOX);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.boombox");
    }

    @Override
    public CompoundNBT instructionFromClient(ServerPlayerEntity player, String s, CompoundNBT tag) {
        if (s.equals("Mode")) {
            this.setMode(BoomboxMode.getScreenByName(tag.func_74779_i("name")));
        } else if (s.equals("Stop")) {
            this.musciPlayStop();
        } else if (s.equals("Loop")) {
            this.setMusicLoop(tag.func_74767_n("enble"));
        } else if (s.equals("VolumeUp")) {
            if (this.getMusicVolumeN() + 10 <= 200) {
                this.setMusicVolume(this.getMusicVolumeN() + 10);
            }
        } else if (s.equals("VolumeDown")) {
            if (this.getMusicVolumeN() - 10 >= 0) {
                this.setMusicVolume(this.getMusicVolumeN() - 10);
            }
        } else if (s.equals("VolumeMute")) {
            this.setMusicVolumeMute(tag.func_74767_n("enble"));
        }
        return super.instructionFromClient(player, s, tag);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new BoomboxContainer(id, player, (IInventory)this, this.func_174877_v());
    }

    public BoomboxMode getMode() {
        return (BoomboxMode)((Object)this.func_195044_w().func_177229_b(BoomboxBlock.BOOMBOX_MODE));
    }

    public void setMode(BoomboxMode mode) {
        this.setBlockState((BlockState)this.func_195044_w().func_206870_a(BoomboxBlock.BOOMBOX_MODE, (Comparable)((Object)mode)));
    }

    @Override
    public void readByIKSG(BlockState state, CompoundNBT tag) {
        super.readByIKSG(state, tag);
        this.currentPlayPos = tag.func_74763_f("CurrentPlayPos");
        this.playWaiting = tag.func_74767_n("PlayWaiting");
        this.musicLoop = tag.func_74767_n("MusicLoop");
        this.musicVolume = tag.func_74762_e("MusicVolume");
        this.musicVolumeMute = tag.func_74767_n("MusicVolumeMute");
        this.isRedStoneOn = tag.func_74767_n("RedStoneOn");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74772_a("CurrentPlayPos", this.currentPlayPos);
        tag.func_74757_a("PlayWaiting", this.playWaiting);
        tag.func_74757_a("MusicLoop", this.musicLoop);
        tag.func_74768_a("MusicVolume", this.musicVolume);
        tag.func_74757_a("MusicVolumeMute", this.musicVolumeMute);
        tag.func_74757_a("RedStoneOn", this.isRedStoneOn);
        return super.func_189515_b(tag);
    }

    @Override
    protected int getInventorySize() {
        return 1;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.func_201670_d()) {
            if (this.getMode() == BoomboxMode.PLAY && !this.isMusicPlaying()) {
                this.musicPlay();
            }
            if (this.getMode() == BoomboxMode.PAUSE && this.getCassetteTape().func_190926_b()) {
                this.setMode(BoomboxMode.NONE);
            }
            if (this.getMode() == BoomboxMode.NONE || this.getCassetteTape().func_190926_b()) {
                this.setCurrentMusicPlayPosition(0L);
            }
            if (!this.isOn()) {
                this.setMode(BoomboxMode.NONE);
            }
            this.playWaiting = this.isMusicPlayWaiting();
            if (!(this.isOn() && this.getMode() == BoomboxMode.PLAY || !this.func_145831_w().func_175640_z(this.func_174877_v()) || this.getCassetteTape().func_190926_b())) {
                this.setBlockState((BlockState)this.func_195044_w().func_206870_a((Property)IMPAbstractEquipmentBlock.ON, (Comparable)Boolean.valueOf(true)));
                this.setMusicLoop(true);
                this.setMode(BoomboxMode.PLAY);
                this.isRedStoneOn = true;
            }
            if (this.isRedStoneOn && !this.func_145831_w().func_175640_z(this.func_174877_v())) {
                this.setMusicLoop(false);
                this.setMode(BoomboxMode.NONE);
                this.isRedStoneOn = false;
            }
        }
    }

    public void musciPlayStop() {
        this.setMode(BoomboxMode.NONE);
    }

    public ItemStack getCassetteTape() {
        return (ItemStack)this.getItems().get(0);
    }

    public boolean isPlayWaiting() {
        return this.playWaiting;
    }

    public void setMusicVolume(int musicVolume) {
        this.musicVolume = musicVolume;
    }

    public int getMusicVolumeN() {
        return this.musicVolume;
    }

    public void setMusicLoop(boolean loop) {
        this.musicLoop = loop;
    }

    @Override
    public boolean canMusicPlay() {
        return this.func_145831_w().field_147482_g.contains(this) && this.func_145831_w().func_175667_e(this.func_174877_v()) && this.getMode() == BoomboxMode.PLAY && !this.getCassetteTape().func_190926_b() && this.isOn();
    }

    public void setMusicVolumeMute(boolean musicVolumeMute) {
        this.musicVolumeMute = musicVolumeMute;
    }

    public boolean isMusicVolumeMute() {
        return this.musicVolumeMute;
    }

    @Override
    public void musicPlayed() {
    }

    @Override
    public void musicStoped() {
        this.setMode(BoomboxMode.NONE);
    }

    @Override
    public long getCurrentMusicPlayPosition() {
        return this.currentPlayPos;
    }

    @Override
    public void setCurrentMusicPlayPosition(long position) {
        this.currentPlayPos = position;
    }

    @Override
    public UUID getMusicPlayerUUID() {
        return this.mPlayerUUID;
    }

    @Override
    public PlayMusic getMusic() {
        return ItemHelper.getPlayMusicByItem(this.getCassetteTape());
    }

    @Override
    public Vector3d getMusicPos() {
        return new Vector3d((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f));
    }

    @Override
    public ResourceLocation getMusicDimension() {
        return Objects.requireNonNull(this.func_145831_w()).func_234923_W_().func_240901_a_();
    }

    @Override
    public boolean isMusicLoop() {
        return this.musicLoop;
    }

    @Override
    public float getMusicVolume() {
        return this.isMusicVolumeMute() ? 0.0f : (float)this.getMusicVolumeN() / 100.0f;
    }
}

