/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.imp.tileentity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import red.felnull.imp.container.MusicSharingDeviceContainer;
import red.felnull.imp.data.PlayListGuildManeger;
import red.felnull.imp.data.PlayMusicManeger;
import red.felnull.imp.music.resource.PlayList;
import red.felnull.imp.music.resource.PlayMusic;
import red.felnull.imp.tileentity.IMPAbstractPAPLEquipmentTileEntity;
import red.felnull.imp.tileentity.IMPTileEntityTypes;
import red.felnull.imp.util.ItemHelper;
import red.felnull.otyacraftengine.util.IKSGNBTUtil;
import red.felnull.otyacraftengine.util.IKSGPlayerUtil;
import red.felnull.otyacraftengine.util.IKSGServerUtil;

public class MusicSharingDeviceTileEntity
extends IMPAbstractPAPLEquipmentTileEntity {
    private Map<String, CompoundNBT> plyerDatas = new HashMap<String, CompoundNBT>();

    public MusicSharingDeviceTileEntity() {
        super(IMPTileEntityTypes.MUSIC_SHARING_DEVICE);
    }

    @Override
    public void readByIKSG(BlockState state, CompoundNBT tag) {
        super.readByIKSG(state, tag);
        this.plyerDatas = IKSGNBTUtil.readNBTMap((CompoundNBT)tag.func_74775_l("plyerDatas"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("plyerDatas", (INBT)IKSGNBTUtil.writeNBTMap((CompoundNBT)new CompoundNBT(), this.plyerDatas));
        return tag;
    }

    @Override
    protected int getInventorySize() {
        return 1;
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.music_sharing_device");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new MusicSharingDeviceContainer(id, player, (IInventory)this, this.func_174877_v());
    }

    @Override
    public CompoundNBT instructionFromClient(ServerPlayerEntity player, String s, CompoundNBT tag) {
        if (s.equals("Mode")) {
            this.setScreen((PlayerEntity)player, Screen.getScreenByName(tag.func_74779_i("name")));
        } else if (s.equals("PathSet")) {
            this.setPath((PlayerEntity)player, tag.func_74779_i("path"));
        } else {
            if (s.equals("CanJoinPlayListUpdate")) {
                return this.getUpdateCanJoinPlayListTag(player);
            }
            if (s.equals("PlaylistDetailsSet")) {
                this.setLastPLDetalsName((PlayerEntity)player, tag.func_74779_i("PLName"));
                this.setPLDetalsACheckbox((PlayerEntity)player, tag.func_74767_n("Checked"));
            } else {
                if (s.equals("AllPlayListPlayersUpdate")) {
                    return this.getUpdatePlayListPlayersTag(player, tag.func_74779_i("uuid"));
                }
                if (s.equals("LastPlayMusicSet")) {
                    this.setLastPlayMusic((PlayerEntity)player, tag.func_74779_i("uuid"));
                }
            }
        }
        return super.instructionFromClient(player, s, tag);
    }

    private CompoundNBT getUpdatePlayListPlayersTag(ServerPlayerEntity playerEntity, String uuid) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("uuid", uuid);
        tag.func_218657_a("list", (INBT)PlayMusicManeger.instance().getAllPlayerNBT(playerEntity, PlayList.getPlayListByUUID(uuid)));
        return tag;
    }

    private CompoundNBT getUpdateCanJoinPlayListTag(ServerPlayerEntity player) {
        return PlayListGuildManeger.instance().getAllPlayListNBT(player, false);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.plyerDatas.forEach((n, m) -> {
                if (!IKSGServerUtil.isOnlinePlayer((String)n)) {
                    this.setPath((String)n, null);
                }
                if (ItemHelper.isAntenna(this.getPAntenna())) {
                    if (this.getScreen((String)n) == Screen.NO_ANTENNA) {
                        this.setScreen((String)n, Screen.PLAYLIST);
                    }
                } else if (this.getScreen((String)n) != Screen.NO_ANTENNA) {
                    this.setScreen((String)n, Screen.NO_ANTENNA);
                }
                if (this.isOn()) {
                    if (this.getScreen((String)n) == Screen.OFF) {
                        this.setScreen((String)n, Screen.PLAYLIST);
                    }
                } else if (this.getScreen((String)n) != Screen.OFF) {
                    this.setScreen((String)n, Screen.OFF);
                }
            });
        }
    }

    public void setPath(String pluuid, String path) {
        if (path == null) {
            this.getPlayerData(pluuid).func_82580_o("Path");
        } else {
            this.getPlayerData(pluuid).func_74778_a("Path", path);
        }
    }

    public void setPath(PlayerEntity pl, String path) {
        if (path == null || path.isEmpty()) {
            this.getPlayerData(pl).func_82580_o("Path");
        } else {
            this.getPlayerData(pl).func_74778_a("Path", path);
        }
    }

    public String getPLDetalsName(PlayerEntity pl) {
        return this.getPlayerData(pl).func_74779_i("PlaylistDetailsName");
    }

    public boolean getPLDetalsACheckbox(PlayerEntity pl) {
        return this.getPlayerData(pl).func_74767_n("PlaylistDetailsACheckbox");
    }

    public String getPlayerPath(PlayerEntity pl) {
        return this.getPlayerData(pl).func_74779_i("Path");
    }

    public PlayMusic getLastPlayMusic(PlayerEntity pl) {
        CompoundNBT tag = this.getPlayerData(IKSGPlayerUtil.getUUID((PlayerEntity)pl));
        return new PlayMusic(tag.func_74779_i("LastPlayMusicUUID"), tag.func_74775_l("LastPlayMusic"));
    }

    public void setScreen(String pluuid, Screen screen) {
        this.getPlayerData(pluuid).func_74778_a("PlayerCurrentScreen", screen.getName());
    }

    public void setLastPLDetalsName(PlayerEntity pl, String lastDetalsPLname) {
        this.getPlayerData(pl).func_74778_a("PlaylistDetailsName", lastDetalsPLname);
    }

    public void setLastPlayMusic(PlayerEntity pl, String uuid) {
        PlayMusic music = PlayMusic.getPlayMusicByUUID(uuid);
        this.getPlayerData(pl).func_74778_a("LastPlayMusicUUID", uuid);
        this.getPlayerData(pl).func_218657_a("LastPlayMusic", (INBT)music.write(new CompoundNBT()));
    }

    public void setPLDetalsACheckbox(PlayerEntity pl, boolean cheked) {
        this.getPlayerData(pl).func_74757_a("PlaylistDetailsACheckbox", cheked);
    }

    public void setScreen(PlayerEntity pl, Screen screen) {
        this.getPlayerData(pl).func_74778_a("PlayerCurrentScreen", screen.getName());
    }

    public Screen getScreen(String pluuid) {
        return Screen.getScreenByName(this.getPlayerData(pluuid).func_74779_i("PlayerCurrentScreen"));
    }

    public Screen getScreen(PlayerEntity pl) {
        return Screen.getScreenByName(this.getPlayerData(pl).func_74779_i("PlayerCurrentScreen"));
    }

    private CompoundNBT getPlayerData(String pluuid) {
        if (!this.plyerDatas.containsKey(pluuid)) {
            this.plyerDatas.put(pluuid, new CompoundNBT());
        }
        return this.plyerDatas.get(pluuid);
    }

    private CompoundNBT getPlayerData(PlayerEntity pl) {
        String uuid = IKSGPlayerUtil.getUUID((PlayerEntity)pl);
        if (!this.plyerDatas.containsKey(uuid)) {
            this.plyerDatas.put(uuid, new CompoundNBT());
        }
        return this.plyerDatas.get(uuid);
    }

    public static enum Screen {
        OFF("off"),
        ON("on"),
        PLAYLIST("playlist"),
        NOTEXIST("notexist"),
        NO_ANTENNA("no_antenna"),
        CREATE_PLAYLIST("create_playlist"),
        ADD_PLAYLIST("add_playlist"),
        JOIN_PLAYLIST("join_playlist"),
        ADD_PLAYMUSIC_1("add_playmusic_1"),
        ADD_PLAYMUSIC_2("add_playmusic_2"),
        YOUTUBE_SEARCH("youtube_search"),
        PLAYLIST_DETAILS("playlist_details"),
        PLAYLIST_REMOVE("playlist_remove"),
        PLAYMUSIC_DETAILS("playmusic_details"),
        PLAYMUSIC_REMOVE("playmusic_remove");

        private final String name;

        private Screen(String name) {
            this.name = name;
        }

        public static Screen getScreenByName(String name) {
            for (Screen sc : Screen.values()) {
                if (!sc.getName().equals(name)) continue;
                return sc;
            }
            return OFF;
        }

        public String getName() {
            return this.name;
        }

        public ResourceLocation getTexLocation() {
            return new ResourceLocation("iammusicplayer", "textures/gui/music_sharing_device_screen/" + this.getName() + ".png");
        }
    }
}

