/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.client.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import red.felnull.otyacraftengine.api.event.common.ReceiverEvent;
import red.felnull.otyacraftengine.api.registries.OERegistries;
import red.felnull.otyacraftengine.data.DataReceiverBuffer;
import red.felnull.otyacraftengine.data.SendReceiveLogger;
import red.felnull.otyacraftengine.util.IKSGFileLoadUtil;

public class ClientDataReceiver
extends Thread {
    private static final Map<String, DataReceiverBuffer> RECEIVS = new HashMap<String, DataReceiverBuffer>();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final String name;
    private final String uuid;
    private final ResourceLocation location;
    private final SendReceiveLogger logger;
    private int cont;
    private final long fristTime;
    private long logTime;

    @OnlyIn(value=Dist.CLIENT)
    public ClientDataReceiver(String uuid, ResourceLocation location, String name, int datasize) {
        this.uuid = uuid;
        this.location = location;
        this.name = name;
        this.fristTime = System.currentTimeMillis();
        this.logTime = System.currentTimeMillis();
        RECEIVS.put(uuid, new DataReceiverBuffer(datasize, uuid, location, name));
        String det = "UUID:" + uuid + " Location:" + location.toString() + " Name:" + name + " Size:" + datasize + "byte";
        this.logger = new SendReceiveLogger(location.toString(), det, Dist.CLIENT, SendReceiveLogger.SndOrRec.RECEIVE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addBufferBytes(String uuid, byte[] bytes) {
        if (RECEIVS.containsKey(uuid)) {
            RECEIVS.get(uuid).addBytes(bytes);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void receiveFinish(SendReceiveLogger.SRResult result) {
        this.logger.addFinishLogLine(result, System.currentTimeMillis() - this.fristTime, RECEIVS.get(this.uuid).getCont());
        RECEIVS.remove(this.uuid);
        this.logger.createLog();
        MinecraftForge.EVENT_BUS.post((Event)new ReceiverEvent.Client.Pos(this.uuid, this.location, this.name, result));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void run() {
        try {
            this.logger.addStartLogLine();
            MinecraftForge.EVENT_BUS.post((Event)new ReceiverEvent.Client.Pre(this.uuid, this.location, this.name));
            long time = System.currentTimeMillis();
            while (!RECEIVS.get(this.uuid).isPerfectByte()) {
                if (System.currentTimeMillis() - this.logTime >= 3000L) {
                    this.logger.addProgress(RECEIVS.get(this.uuid).getCont(), ClientDataReceiver.RECEIVS.get((Object)this.uuid).allcont - RECEIVS.get(this.uuid).getCont(), System.currentTimeMillis() - this.fristTime, System.currentTimeMillis() - time, SendReceiveLogger.SndOrRec.RECEIVE);
                    this.logTime = System.currentTimeMillis();
                }
                if (ClientDataReceiver.RECEIVS.get((Object)this.uuid).stop) {
                    this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.stop"));
                    this.receiveFinish(SendReceiveLogger.SRResult.FAILURE);
                    return;
                }
                if (ClientDataReceiver.mc.field_71439_g == null) {
                    this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.playerExitedWorld"));
                    this.receiveFinish(SendReceiveLogger.SRResult.FAILURE);
                    return;
                }
                if (this.cont == RECEIVS.get(this.uuid).getCont() && System.currentTimeMillis() - time >= 10000L) {
                    this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.timeout"));
                    this.receiveFinish(SendReceiveLogger.SRResult.FAILURE);
                    return;
                }
                if (this.cont != RECEIVS.get(this.uuid).getCont()) {
                    this.cont = RECEIVS.get(this.uuid).getCont();
                    time = System.currentTimeMillis();
                    MinecraftForge.EVENT_BUS.post((Event)new ReceiverEvent.Client.Run(this.uuid, this.location, this.name, ClientDataReceiver.RECEIVS.get((Object)this.uuid).allcont, this.cont));
                }
                ClientDataReceiver.sleep(1L);
            }
            IKSGFileLoadUtil.fileBytesWriter(RECEIVS.get(this.uuid).getBytes(), OERegistries.CLIENT_RECEVED_PATH.get(this.location).resolve(this.name));
        }
        catch (Exception ex) {
            this.logger.addExceptionLogLine(ex);
            ex.printStackTrace();
            this.receiveFinish(SendReceiveLogger.SRResult.FAILURE);
        }
        this.receiveFinish(SendReceiveLogger.SRResult.SUCCESS);
    }
}

