/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.client.data;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import red.felnull.otyacraftengine.OtyacraftEngine;
import red.felnull.otyacraftengine.api.event.common.SenderEvent;
import red.felnull.otyacraftengine.data.SendReceiveLogger;
import red.felnull.otyacraftengine.packet.ClientDataSendMessage;
import red.felnull.otyacraftengine.packet.PacketHandler;
import red.felnull.otyacraftengine.util.IKSGFileLoadUtil;
import red.felnull.otyacraftengine.util.IKSGStringUtil;

public class ClientDataSender
extends Thread {
    public static int max = 5;
    private static final Map<String, ClientDataSender> SENDS = new HashMap<String, ClientDataSender>();
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final String name;
    private final String uuid;
    private final ResourceLocation location;
    private final SendReceiveLogger logger;
    private final long fristTime;
    public int dataCont;
    public boolean response = false;
    private byte[] sendingData;
    private boolean stop;
    private long logTime;
    private long lastResponseTime;
    private long time;

    @OnlyIn(value=Dist.CLIENT)
    public ClientDataSender(String uuid, ResourceLocation location, String name, byte[] data) {
        this.name = name;
        this.uuid = uuid;
        this.sendingData = data;
        this.location = location;
        String det = "UUID:" + uuid + " Location:" + location.toString() + " Name:" + name + " Size:" + (data == null ? "0" : Integer.valueOf(data.length)) + "byte";
        this.logger = new SendReceiveLogger(location.toString(), det, Dist.CLIENT, SendReceiveLogger.SndOrRec.SEND);
        this.fristTime = System.currentTimeMillis();
        this.logTime = System.currentTimeMillis();
        this.lastResponseTime = System.currentTimeMillis();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isMaxSending() {
        return SENDS.size() >= max;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void response(String uuid) {
        if (SENDS.containsKey(uuid)) {
            ClientDataSender.SENDS.get((Object)uuid).response = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sending(String uuid, ResourceLocation location, String name, byte[] data) {
        ClientDataSender cds = new ClientDataSender(uuid, location, name, data);
        cds.sendStart();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void srlogsGziping() {
        if (!Paths.get("srlogs", new String[0]).toFile().exists()) {
            return;
        }
        File[] files = Paths.get("srlogs", new String[0]).toFile().listFiles(file -> IKSGStringUtil.getExtension(file.getName()).equals("log"));
        if (files.length == 0) {
            return;
        }
        File mostold = null;
        File mostnew = null;
        for (File file2 : files) {
            if (mostold == null || mostnew == null) {
                mostold = file2;
                mostnew = file2;
                continue;
            }
            if (mostold.lastModified() < file2.lastModified()) {
                mostold = file2;
            }
            if (mostnew.lastModified() <= file2.lastModified()) continue;
            mostnew = file2;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (File file3 : files) {
                byte[] bytes = IKSGFileLoadUtil.fileBytesReader(file3.toPath());
                GZIPOutputStream gzip_out = new GZIPOutputStream(out);
                gzip_out.write(Objects.requireNonNull(bytes));
                gzip_out.close();
            }
            out.close();
            byte[] ret = out.toByteArray();
            String name = mostold == mostnew ? mostnew.getName() : IKSGStringUtil.deleteExtension(mostold.getName()) + "~" + IKSGStringUtil.deleteExtension(mostnew.getName());
            IKSGFileLoadUtil.fileBytesWriter(ret, Paths.get("srlogs\\" + name + ".log.gz", new String[0]));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        for (File file4 : files) {
            IKSGFileLoadUtil.deleteFile(file4);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendStart() {
        if (ClientDataSender.isMaxSending()) {
            OtyacraftEngine.LOGGER.error("The data cont that can be sent at one time is exceeded : " + this.location.toString() + " : " + this.name);
            this.sendingData = null;
            this.logger.addStartFailureLogLine((ITextComponent)new TranslationTextComponent("rslog.err.excessSimultaneousSending"));
            this.logger.addFinishLogLine(SendReceiveLogger.SRResult.FAILURE, System.currentTimeMillis() - this.fristTime, this.sendingData == null ? 0 : this.sendingData.length);
            this.logger.createLog();
            return;
        }
        SENDS.put(this.uuid, this);
        this.start();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sentFinish(SendReceiveLogger.SRResult result) {
        this.logger.addFinishLogLine(result, System.currentTimeMillis() - this.fristTime, this.sendingData.length);
        this.sendingData = null;
        SENDS.remove(this.uuid);
        this.logger.createLog();
        MinecraftForge.EVENT_BUS.post((Event)new SenderEvent.Client.Pos(this.uuid, this.location, this.name, result));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void run() {
        try {
            if (this.sendingData == null) {
                OtyacraftEngine.LOGGER.info("Null Sender Data : " + this.location.toString() + " : " + this.name);
                this.logger.addStartFailureLogLine((ITextComponent)new TranslationTextComponent("rslog.err.nulldata"));
                this.sentFinish(SendReceiveLogger.SRResult.FAILURE);
                return;
            }
            this.logger.addStartLogLine();
            MinecraftForge.EVENT_BUS.post((Event)new SenderEvent.Client.Pre(this.uuid, this.location, this.name));
            boolean frist = true;
            int sendbyte = 8192;
            int soundbytelengt = this.sendingData.length;
            for (int i = 0; i < soundbytelengt; i += sendbyte) {
                byte[] sndingbyte = new byte[Math.min(soundbytelengt - i, sendbyte)];
                System.arraycopy(this.sendingData, i, sndingbyte, 0, sndingbyte.length);
                this.dataCont += sndingbyte.length;
                ClientDataSendMessage sendpacet = frist ? new ClientDataSendMessage(this.uuid, this.location, this.name, sndingbyte, this.sendingData.length, true) : new ClientDataSendMessage(this.uuid, sndingbyte);
                PacketHandler.INSTANCE.sendToServer((Object)sendpacet);
                MinecraftForge.EVENT_BUS.post((Event)new SenderEvent.Client.Run(this.uuid, this.location, this.name, this.sendingData.length, this.dataCont));
                sndingbyte = null;
                frist = false;
                this.time = System.currentTimeMillis();
                while (!this.response) {
                    if (System.currentTimeMillis() - this.logTime >= 3000L) {
                        this.logTime = System.currentTimeMillis();
                        this.logger.addProgress(this.dataCont, this.sendingData.length - this.dataCont, System.currentTimeMillis() - this.fristTime, System.currentTimeMillis() - this.lastResponseTime, SendReceiveLogger.SndOrRec.SEND);
                    }
                    if (ClientDataSender.mc.field_71439_g == null) {
                        this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.playerExitedWorld"));
                        this.sentFinish(SendReceiveLogger.SRResult.FAILURE);
                        return;
                    }
                    if (this.stop) {
                        this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.stop"));
                        this.sentFinish(SendReceiveLogger.SRResult.FAILURE);
                        return;
                    }
                    if (System.currentTimeMillis() - this.time >= 10000L) {
                        this.logger.addLogLine((ITextComponent)new TranslationTextComponent("rslog.err.timeout"));
                        this.sentFinish(SendReceiveLogger.SRResult.FAILURE);
                        return;
                    }
                    ClientDataSender.sleep(1L);
                }
                this.response = false;
                this.lastResponseTime = System.currentTimeMillis();
            }
        }
        catch (Exception ex) {
            this.logger.addExceptionLogLine(ex);
            ex.printStackTrace();
            this.sentFinish(SendReceiveLogger.SRResult.FAILURE);
        }
        this.sentFinish(SendReceiveLogger.SRResult.SUCCESS);
    }
}

