/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.client.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import red.felnull.otyacraftengine.OtyacraftEngine;
import red.felnull.otyacraftengine.api.ResponseSender;
import red.felnull.otyacraftengine.client.config.ClientConfig;
import red.felnull.otyacraftengine.client.util.IKSGClientUtil;
import red.felnull.otyacraftengine.client.util.IKSGTextureUtil;
import red.felnull.otyacraftengine.packet.PacketHandler;
import red.felnull.otyacraftengine.packet.ReceiveTextureHashCheckMessage;
import red.felnull.otyacraftengine.util.IKSGFileLoadUtil;
import red.felnull.otyacraftengine.util.IKSGPathUtil;

public class ReceiveTextureLoder {
    public static final Path CASH_PATH = IKSGPathUtil.getOEReceiveTexturesPath();
    private static ReceiveTextureLoder INSTANCE;
    public final Map<String, String> INDEX_UUID = new HashMap<String, String>();
    public final Map<String, ResourceLocation> PICTUER_RECEIVE_LOCATION = new HashMap<String, ResourceLocation>();
    private final Map<String, String> INDEX = new HashMap<String, String>();
    public final Map<ResourceLocation, Map<String, Long>> LAST_UPDATE = new HashMap<ResourceLocation, Map<String, Long>>();

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        INSTANCE = new ReceiveTextureLoder();
        Timer timer = new Timer();
        TimerTask hashCheckRegularlyTask = new TimerTask(){

            @Override
            public void run() {
                ReceiveTextureLoder.instance().hashCheckRegularly(false);
            }
        };
        timer.scheduleAtFixedRate(hashCheckRegularlyTask, 0L, 10000L);
    }

    public static ReceiveTextureLoder instance() {
        return INSTANCE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void requestTextuerSend(String indexnaxme, ResourceLocation location, String name) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("location", location.toString());
        tag.func_74778_a("index", indexnaxme);
        ResponseSender.sendToServer(new ResourceLocation("otyacraftengine", "textuerrequest"), 0, name, tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getIndexContainLocation(String string) {
        if (this.INDEX.containsKey(string)) {
            return this.INDEX.get(string);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setNotFind(String index) {
        this.PICTUER_RECEIVE_LOCATION.put(index, IKSGTextureUtil.TEXTUER_NOTFINED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void requestedTextuerReceive(String uuid, String name) {
        if (!this.INDEX_UUID.containsKey(uuid)) {
            return;
        }
        String indexname = this.INDEX_UUID.get(uuid);
        this.INDEX.put(indexname, name);
        ResourceLocation inmap = IKSGTextureUtil.getPictureImageTexture(IKSGFileLoadUtil.fileBytesReader(CASH_PATH.resolve("cash").resolve(name)));
        this.PICTUER_RECEIVE_LOCATION.put(indexname, inmap);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void deleteUnnecessaryCash() {
        if (!((Boolean)ClientConfig.DeleteUnnecessaryTextureCash.get()).booleanValue() || !CASH_PATH.resolve("index.json").toFile().exists()) {
            return;
        }
        try {
            InputStreamReader reader = new InputStreamReader(new FileInputStream(CASH_PATH.resolve("index.json").toFile()));
            JsonReader jsonReader = new JsonReader((Reader)reader);
            Gson gson = new Gson();
            HashMap map = new HashMap((Map)gson.fromJson(jsonReader, HashMap.class));
            File[] cfiles = CASH_PATH.resolve("cash").toFile().listFiles();
            Arrays.stream((Object[])Objects.requireNonNull(cfiles)).filter(n -> !map.containsValue(n.getName())).forEach(IKSGFileLoadUtil::deleteFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateTextuerClient(ResourceLocation location, String name) {
        String WORLDNAME_AND_PATH = IKSGClientUtil.getCurrentWorldUUID() + ":" + location.toString() + ":" + name;
        if (!CASH_PATH.resolve("index.json").toFile().exists()) {
            return;
        }
        if (!this.INDEX.containsKey(WORLDNAME_AND_PATH) || !CASH_PATH.resolve("cash").resolve(this.INDEX.get(WORLDNAME_AND_PATH)).toFile().exists()) {
            this.PICTUER_RECEIVE_LOCATION.remove(WORLDNAME_AND_PATH);
            return;
        }
        IKSGFileLoadUtil.deleteFile(CASH_PATH.resolve("cash").resolve(this.INDEX.get(WORLDNAME_AND_PATH)));
        this.INDEX.remove(WORLDNAME_AND_PATH);
        this.PICTUER_RECEIVE_LOCATION.remove(WORLDNAME_AND_PATH);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void writeClientIndex() {
        File index = CASH_PATH.resolve("index.json").toFile();
        IKSGFileLoadUtil.createFolder(CASH_PATH);
        try (FileWriter writer = new FileWriter(index);){
            Gson gsonb = new GsonBuilder().create();
            gsonb.toJson(this.INDEX, (Appendable)writer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readClientIndex() {
        File index = CASH_PATH.resolve("index.json").toFile();
        if (index.exists()) {
            try {
                InputStreamReader reader = new InputStreamReader(new FileInputStream(index));
                JsonReader jsonReader = new JsonReader((Reader)reader);
                Gson gson = new Gson();
                this.INDEX.clear();
                this.INDEX.putAll((Map)gson.fromJson(jsonReader, this.INDEX.getClass()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void hashCheckRegularly(boolean all) {
        if (OtyacraftEngine.proxy.getMinecraft().field_71439_g != null) {
            HashMap<ResourceLocation, Map<String, Integer>> checkblemap = new HashMap<ResourceLocation, Map<String, Integer>>();
            if (!all) {
                this.PICTUER_RECEIVE_LOCATION.entrySet().stream().filter(n -> ((String)n.getKey()).split(":")[0].equals(IKSGClientUtil.getCurrentWorldUUID().toString())).filter(n -> {
                    String[] str = ((String)n.getKey()).split(":");
                    ResourceLocation location = new ResourceLocation(str[1], str[2]);
                    return this.isRecentlyUpdateble(location, str[3]);
                }).forEach(n -> {
                    try {
                        File texFile;
                        String[] str = ((String)n.getKey()).split(":");
                        ResourceLocation location = new ResourceLocation(str[1], str[2]);
                        if (!checkblemap.containsKey(location)) {
                            checkblemap.put(location, new HashMap());
                        }
                        int sha = 0;
                        if (!((ResourceLocation)n.getValue()).equals((Object)IKSGTextureUtil.TEXTUER_NOTFINED) && (texFile = CASH_PATH.resolve("cash").resolve(this.INDEX.get(n.getKey())).toFile()).exists()) {
                            try {
                                sha = IKSGFileLoadUtil.getCheckSum(texFile);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        ((Map)checkblemap.get(location)).put(str[3], sha);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            } else {
                this.INDEX.entrySet().stream().filter(n -> ((String)n.getKey()).split(":")[0].equals(IKSGClientUtil.getCurrentWorldUUID().toString())).forEach(n -> {
                    String[] str = ((String)n.getKey()).split(":");
                    ResourceLocation location = new ResourceLocation(str[1], str[2]);
                    if (!checkblemap.containsKey(location)) {
                        checkblemap.put(location, new HashMap());
                    }
                    int sha = 0;
                    File texFile = CASH_PATH.resolve("cash").resolve((String)n.getValue()).toFile();
                    if (texFile.exists()) {
                        sha = texFile.hashCode();
                    }
                    ((Map)checkblemap.get(location)).put(str[3], sha);
                });
            }
            PacketHandler.INSTANCE.sendToServer((Object)new ReceiveTextureHashCheckMessage(checkblemap));
        }
    }

    public void updateLastTextuerTime(ResourceLocation location, String name) {
        if (!this.LAST_UPDATE.containsKey(location)) {
            this.LAST_UPDATE.put(location, new HashMap());
        }
        this.LAST_UPDATE.get(location).put(name, System.currentTimeMillis());
    }

    public boolean isRecentlyUpdateble(ResourceLocation location, String name) {
        if (this.LAST_UPDATE.containsKey(location) && this.LAST_UPDATE.get(location).containsKey(name)) {
            return System.currentTimeMillis() - this.LAST_UPDATE.get(location).get(name) < 180000L;
        }
        return false;
    }
}

