/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.client.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import red.felnull.otyacraftengine.client.config.ClientConfig;
import red.felnull.otyacraftengine.client.util.IKSGTextureUtil;
import red.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNDataUtil;
import red.felnull.otyacraftengine.libs.dev.felnull.fnjl.util.FNURLUtil;
import red.felnull.otyacraftengine.util.IKSGFileLoadUtil;
import red.felnull.otyacraftengine.util.IKSGPathUtil;
import red.felnull.otyacraftengine.util.IKSGPictuerUtil;

public class URLImageTextureLoder {
    public static final Path CASH_PATH = IKSGPathUtil.getOEURLImageTexturesPath();
    private static URLImageTextureLoder INSTANCE;
    public final Map<URLImageData, ResourceLocation> PICTUER_URL_LOCATION = new HashMap<URLImageData, ResourceLocation>();
    private final Map<URLImageData, String> INDEX = new HashMap<URLImageData, String>();

    public static URLImageTextureLoder instance() {
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new URLImageTextureLoder();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void downloadTextuer(URLImageData urldata) {
        TextuerDownloadThread tdt = new TextuerDownloadThread(urldata);
        tdt.start();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getIndexContainLocation(URLImageData string) {
        if (this.INDEX.containsKey(string)) {
            return this.INDEX.get(string);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void writeClientIndex() {
        File index = CASH_PATH.resolve("index.json").toFile();
        IKSGFileLoadUtil.createFolder(CASH_PATH);
        try (FileWriter writer = new FileWriter(index);){
            Gson gsonb = new GsonBuilder().create();
            JsonObject jo = new JsonObject();
            this.INDEX.forEach((n, m) -> jo.add(m, (JsonElement)n.toJsonObject()));
            gsonb.toJson((JsonElement)jo, (Appendable)writer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void deleteUnnecessaryCash() {
        if (!((Boolean)ClientConfig.DeleteUnnecessaryTextureCash.get()).booleanValue() || !CASH_PATH.resolve("index.json").toFile().exists()) {
            return;
        }
        try {
            InputStreamReader reader = new InputStreamReader(new FileInputStream(CASH_PATH.resolve("index.json").toFile()));
            JsonReader jsonReader = new JsonReader((Reader)reader);
            Gson gson = new Gson();
            HashMap map = new HashMap((Map)gson.fromJson(jsonReader, HashMap.class));
            File[] cfiles = CASH_PATH.resolve("cash").toFile().listFiles();
            Arrays.stream((Object[])Objects.requireNonNull(cfiles)).filter(n -> !map.containsValue(n.getName())).forEach(IKSGFileLoadUtil::deleteFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readClientIndex() {
        File index = CASH_PATH.resolve("index.json").toFile();
        if (index.exists()) {
            try {
                InputStreamReader reader = new InputStreamReader(new FileInputStream(index));
                JsonReader jsonReader = new JsonReader((Reader)reader);
                Gson gson = new Gson();
                this.INDEX.clear();
                JsonObject jo = (JsonObject)gson.fromJson(jsonReader, JsonObject.class);
                jo.entrySet().forEach(n -> {
                    if (n.getValue() instanceof JsonObject) {
                        this.INDEX.put(URLImageData.ofJsonObject((JsonObject)n.getValue()), (String)n.getKey());
                    }
                });
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class TextuerDownloadThread
    extends Thread {
        private final URLImageData urldata;

        public TextuerDownloadThread(URLImageData urldata) {
            this.urldata = urldata;
        }

        @Override
        public void run() {
            String name = UUID.randomUUID().toString();
            Path texPath = CASH_PATH.resolve("cash").resolve(name);
            try {
                byte[] data = FNDataUtil.streamToByteArray(FNURLUtil.getStream(new URL(this.urldata.getURL())));
                if (this.urldata.isDecidedSuze()) {
                    data = IKSGPictuerUtil.resize(data, this.urldata.getWidth(), this.urldata.getHeight());
                }
                IKSGFileLoadUtil.createFolder(texPath.getParent());
                Files.write(texPath, data, new OpenOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                URLImageTextureLoder.instance().PICTUER_URL_LOCATION.put(this.urldata, IKSGTextureUtil.TEXTUER_NOTFINED);
                return;
            }
            URLImageTextureLoder.instance().INDEX.put(this.urldata, name);
            ResourceLocation inmap = IKSGTextureUtil.getPictureImageTexture(IKSGFileLoadUtil.fileBytesReader(texPath));
            URLImageTextureLoder.instance().PICTUER_URL_LOCATION.put(this.urldata, inmap);
        }
    }

    public static class URLImageData {
        private final String URL;
        private final int width;
        private final int height;

        public URLImageData(String URL2, int width, int height) {
            this.URL = URL2;
            this.width = width;
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public String getURL() {
            return this.URL;
        }

        public boolean isDecidedSuze() {
            return this.width > 0 && this.height > 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            URLImageData that = (URLImageData)o;
            return this.width == that.width && this.height == that.height && Objects.equals(this.URL, that.URL);
        }

        public int hashCode() {
            return Objects.hash(this.URL, this.width, this.height);
        }

        public JsonObject toJsonObject() {
            JsonObject jo = new JsonObject();
            jo.addProperty("url", this.URL);
            jo.addProperty("width", (Number)this.width);
            jo.addProperty("height", (Number)this.height);
            return jo;
        }

        public static URLImageData ofJsonObject(JsonObject json) {
            return new URLImageData(json.get("url").getAsString(), json.get("width").getAsInt(), json.get("height").getAsInt());
        }
    }
}

