/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import red.felnull.otyacraftengine.client.gui.widget.IkisugiWidget;
import red.felnull.otyacraftengine.client.util.IKSGRenderUtil;
import red.felnull.otyacraftengine.util.IKSGMath;

public class ScrollBarSlider
extends IkisugiWidget {
    private final ResourceLocation location;
    private final int texturStartX;
    private final int texturStartY;
    protected int field_230690_l_;
    protected int field_230691_m_;
    protected int size;
    protected float MValue;
    protected float NValue;
    protected int selectedRange;
    protected boolean showRange;

    public ScrollBarSlider(int x, int y, int size, float maxValue, float defValue, int rang) {
        this(x, y, size, maxValue, defValue, rang, 0, 0, IkisugiWidget.OE_WIDGET);
    }

    public ScrollBarSlider(int x, int y, int size, float maxValue, float defValue, int rang, int texStartX, int texStartY, ResourceLocation location) {
        super(x, y, 9, size, (ITextComponent)new TranslationTextComponent("gui.narrate.scrollbar"));
        this.field_230690_l_ = x;
        this.field_230691_m_ = y;
        this.size = size;
        this.MValue = maxValue;
        this.NValue = defValue;
        this.selectedRange = rang;
        this.showRange = false;
        this.location = location;
        this.texturStartX = texStartX;
        this.texturStartY = texStartY;
    }

    @Override
    public void renderBgByIKSG(MatrixStack matrix, int mouseX, int mouseY, float parTick) {
        if (this.showRange) {
            int i;
            int ysra;
            int xsra;
            int ysrk;
            int ysr;
            int xsrk;
            int xsr;
            if (this.selectedRange < 0) {
                xsr = IKSGMath.positiveInt(this.selectedRange);
                xsrk = xsr / 9;
                ysr = this.size - 2;
                ysrk = ysr / 20;
                xsra = xsr - xsrk * 9;
                ysra = ysr - ysrk * 20;
                for (i = 0; i < xsrk; ++i) {
                    IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + i * 9 + this.selectedRange, this.field_230691_m_, this.texturStartX + 18, this.texturStartY + 20, 9, 1, 256, 256);
                    IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + i * 9 + this.selectedRange, this.field_230691_m_ + this.size - 1, this.texturStartX + 18, this.texturStartY + 20, 9, 1, 256, 256);
                }
                IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + xsrk * 9 + this.selectedRange, this.field_230691_m_, this.texturStartX + 18, this.texturStartY + 20, xsra, 1, 256, 256);
                IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + xsrk * 9 + this.selectedRange, this.field_230691_m_ + this.size - 1, this.texturStartX + 18, this.texturStartY + 20, xsra, 1, 256, 256);
                for (i = 0; i < ysrk; ++i) {
                    IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + this.selectedRange, this.field_230691_m_ + 1 + 20 * i, this.texturStartX + 27, this.texturStartY + 21, 1, 20, 256, 256);
                }
                IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + this.selectedRange, this.field_230691_m_ + 1 + 20 * ysrk, this.texturStartX + 27, this.texturStartY + 21, 1, ysra, 256, 256);
            } else {
                xsr = this.selectedRange;
                xsrk = xsr / 9;
                ysr = this.size - 2;
                ysrk = ysr / 20;
                xsra = xsr - xsrk * 9;
                ysra = ysr - ysrk * 20;
                for (i = 0; i < xsrk; ++i) {
                    IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + 9 + i * 9, this.field_230691_m_, this.texturStartX + 18, this.texturStartY + 20, 9, 1, 256, 256);
                    IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + 9 + i * 9, this.field_230691_m_ + this.size - 1, this.texturStartX + 18, this.texturStartY + 20, 9, 1, 256, 256);
                }
                IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + 9 + xsrk * 9, this.field_230691_m_, this.texturStartX + 18, this.texturStartY + 20, xsra, 1, 256, 256);
                IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + 9 + xsrk * 9, this.field_230691_m_ + this.size - 1, this.texturStartX + 18, this.texturStartY + 20, xsra, 1, 256, 256);
                for (i = 0; i < ysrk; ++i) {
                    IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + 9 + this.selectedRange - 1, this.field_230691_m_ + 1 + 20 * i, this.texturStartX + 27, this.texturStartY + 21, 1, 20, 256, 256);
                }
                IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + 9 + this.selectedRange - 1, this.field_230691_m_ + 1 + 20 * ysrk, this.texturStartX + 27, this.texturStartY + 21, 1, ysra, 256, 256);
            }
        }
        int ra = this.isHoveredRange(mouseX, mouseY) ? 9 : 0;
        IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_, this.field_230691_m_, this.texturStartX + ra, this.texturStartY + 20, 9, 1, 256, 256);
        IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_, this.field_230691_m_ + this.size - 1, this.texturStartX + ra, this.texturStartY + 41, 9, 1, 256, 256);
        int si = this.size - 2;
        int sik = si / 20;
        for (int i = 0; i < sik; ++i) {
            IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_, this.field_230691_m_ + 1 + 20 * i, this.texturStartX + ra, this.texturStartY + 21, 9, 20, 256, 256);
        }
        int sia = si - sik * 20;
        IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_, this.field_230691_m_ + 1 + 20 * sik, this.texturStartX + ra, this.texturStartY + 21, 9, sia, 256, 256);
        int hsp = 0;
        if (this.isHoveredByIKSG()) {
            hsp += 7;
        }
        if (this.isHoveredButton(mouseX, mouseY)) {
            hsp += 7;
        }
        int nowPoint = 1 + (int)((float)(this.size - this.getSelectButtonSize()) * this.getValueProportion());
        IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + 1, this.field_230691_m_ + nowPoint, this.texturStartX + hsp, this.texturStartY + 0, 7, 2, 256, 256);
        IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + 1, this.field_230691_m_ + nowPoint + this.getSelectButtonSize() - 5, this.texturStartX + 0 + hsp, this.texturStartY + 17, 7, 3, 256, 256);
        int bsi = this.getSelectButtonSize() - 5;
        int bsik = bsi / 15;
        for (int i = 0; i < bsik; ++i) {
            IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + 1, this.field_230691_m_ + 2 + nowPoint + 15 * i, this.texturStartX + hsp, this.texturStartY + 2, 7, 15, 256, 256);
        }
        int bsia = bsi - bsik * 15;
        IKSGRenderUtil.guiBindAndBlit(this.getTexture(), matrix, this.field_230690_l_ + 1, this.field_230691_m_ + 2 + nowPoint + 15 * bsik, this.texturStartX + hsp, this.texturStartY + 2, 7, bsia, 256, 256);
    }

    @Override
    protected void onDragByIKSG(double mouseX, double mouseY, double p_230983_5_, double p_230983_7_) {
        int crickdSize = (int)(mouseY - (double)this.field_230691_m_);
        if (crickdSize >= this.getSelectButtonSize() / 2 && crickdSize <= this.size - this.getSelectButtonSize() / 2) {
            int cacs = crickdSize - this.getSelectButtonSize() / 2;
            float wari = (float)cacs / (float)(this.size - this.getSelectButtonSize());
            this.setValue(this.MValue * wari);
        } else if (crickdSize <= this.getSelectButtonSize() / 2) {
            this.setValue(0.0f);
        } else if (crickdSize >= this.size - this.getSelectButtonSize() / 2) {
            this.setValue(this.MValue);
        }
        super.onDragByIKSG(mouseX, mouseY, p_230983_5_, p_230983_7_);
    }

    @Override
    public void onClickByIKSG(double mouseX, double mouseY) {
        int crickdSize = (int)(mouseY - (double)this.field_230691_m_);
        if (crickdSize >= this.getSelectButtonSize() / 2 && crickdSize <= this.size - this.getSelectButtonSize() / 2) {
            int cacs = crickdSize - this.getSelectButtonSize() / 2;
            float wari = (float)cacs / (float)(this.size - this.getSelectButtonSize());
            this.setValue(this.MValue * wari);
        } else if (crickdSize <= this.getSelectButtonSize() / 2) {
            this.setValue(0.0f);
        } else if (crickdSize >= this.size - this.getSelectButtonSize() / 2) {
            this.setValue(this.MValue);
        }
        super.onClickByIKSG(mouseX, mouseY);
    }

    protected ResourceLocation getTexture() {
        return this.location;
    }

    private boolean isHoveredRange(int mouseX, int mouseY) {
        boolean flag1 = false;
        boolean flag2 = false;
        if (this.selectedRange < 0) {
            flag1 = mouseX < this.field_230690_l_ && mouseY >= this.field_230691_m_;
            flag2 = mouseX >= this.field_230690_l_ + this.selectedRange && mouseY <= this.field_230691_m_ + this.size;
        } else {
            flag1 = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_;
            flag2 = mouseX <= this.field_230690_l_ + 9 + this.selectedRange && mouseY <= this.field_230691_m_ + this.size;
        }
        return this.isHoveredByIKSG() || flag1 && flag2;
    }

    private boolean isHoveredButton(int mouseX, int mouseY) {
        boolean flag1 = mouseX >= this.field_230690_l_ && (float)mouseY >= (float)this.field_230691_m_ + (float)(this.size - this.getSelectButtonSize()) / this.MValue * this.NValue;
        boolean flag2 = mouseX <= this.field_230690_l_ + 9 && (float)mouseY <= (float)this.field_230691_m_ + (float)(this.size - this.getSelectButtonSize()) / this.MValue * this.NValue + (float)this.getSelectButtonSize();
        return this.isHoveredByIKSG() && flag1 && flag2;
    }

    public int getSelectButtonSize() {
        return 32;
    }

    protected float getValueProportion() {
        return this.NValue / this.MValue;
    }

    public float getValue() {
        return this.NValue;
    }

    public void setValue(float value) {
        this.NValue = value;
    }

    public float getMaxValue() {
        return this.MValue;
    }

    public void setMaxValue(float value) {
        this.MValue = value;
    }

    public int getSelectedRange() {
        return this.selectedRange;
    }

    public void setSelectedRange(int range) {
        this.selectedRange = range;
    }

    public boolean isShowRange() {
        return this.showRange;
    }

    public void setShowRange(boolean show) {
        this.showRange = show;
    }
}

