/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import red.felnull.otyacraftengine.client.gui.widget.IkisugiWidget;
import red.felnull.otyacraftengine.client.gui.widget.ScrollBarSlider;
import red.felnull.otyacraftengine.client.util.IKSGRenderUtil;

public class ScrollListButton
extends IkisugiWidget {
    protected float nowSclooled;
    protected List<ResourceLocation> locations;
    protected int onesize;
    protected int locationCont;
    protected ScrollBarSlider scrollBar;
    private IPressable pressed;

    public ScrollListButton(int x, int y, int sizeX, int sizeY, int sizeOne, int count, ScrollBarSlider scrollBar, List<ResourceLocation> locations, IPressable pressed) {
        this(x, y, sizeX, sizeY, sizeOne, count, 0.0f, locations, pressed);
        this.scrollBar = scrollBar;
    }

    public ScrollListButton(int x, int y, int sizeX, int sizeY, int sizeOne, int count, float defaltscolled, List<ResourceLocation> locations, IPressable pressed) {
        super(x, y, sizeX, sizeY, (ITextComponent)new TranslationTextComponent("gui.narrate.scrolllistbutton"));
        this.pressed = pressed;
        this.locations = locations;
        this.onesize = sizeOne;
        this.locationCont = count;
        this.nowSclooled = defaltscolled;
    }

    public float getNowSclooled() {
        if (this.scrollBar != null) {
            return this.scrollBar.getValue() / this.scrollBar.getMaxValue();
        }
        return this.nowSclooled;
    }

    public void setSclooled(float nowsclooled) {
        this.nowSclooled = nowsclooled;
    }

    @Override
    public void renderBgByIKSG(MatrixStack matrix, int mouseX, int mouseY, float parTick) {
        int allsize = this.onesize * this.getCont();
        int zure = 0;
        if (allsize > this.getYSize()) {
            int zuresize = allsize - this.getYSize();
            zure = (int)((float)zuresize * this.getNowSclooled());
        }
        for (int i = 0; i < this.getCont(); ++i) {
            int y = this.getY() + i * this.onesize - zure;
            if (y < this.getY() - this.onesize || y > this.getY() + this.getYSize()) continue;
            this.renderOneList(matrix, this.getX(), y, i, y < this.getY() ? this.getY() - y : 0, y > this.getY() + this.getYSize() - this.onesize ? -(this.getY() + this.getYSize() - (y + this.onesize)) : 0);
        }
    }

    public void renderOneList(MatrixStack matrix, int x, int y, int num, int upOver, int downOver) {
        IKSGRenderUtil.guiBindAndBlit(this.locations.get(num), matrix, x, y + upOver, 0, upOver, this.getXSize(), this.onesize - downOver, this.getXSize(), this.onesize);
    }

    @Override
    public void onClickByIKSG(double mouseX, double mouseY) {
        int y;
        int sy;
        super.onClickByIKSG(mouseX, mouseY);
        int allsize = this.onesize * this.getCont();
        int zure = 0;
        if (allsize > this.getYSize()) {
            int zuresize = allsize - this.getYSize();
            zure = (int)((float)zuresize * this.getNowSclooled());
        }
        if ((sy = (y = (int)mouseY - this.getY() + zure) / this.onesize) >= this.getCont()) {
            return;
        }
        this.pressed.onPress(this, sy);
    }

    protected int getCont() {
        return this.locationCont;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onPress(ScrollListButton var1, int var2);
    }
}

