/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.client.renderer.texture;

import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.NativeImage;

public class DynamicGifTexture
extends DynamicTexture
implements ITickable {
    private final ImageFrame[] frames;
    private final long duration;
    private int last;

    public DynamicGifTexture(long duration, ImageFrame ... frames) {
        super(frames[0].getImage());
        this.duration = duration;
        this.frames = frames;
    }

    public void func_110550_d() {
        int ct = Math.toIntExact(this.getFrameByTime(System.currentTimeMillis() % this.duration));
        if (ct != this.last) {
            this.field_110566_b = this.frames[ct].getImage();
            this.func_110564_a();
            this.last = ct;
        }
    }

    public void close() {
        super.close();
        if (this.frames != null) {
            for (ImageFrame image : this.frames) {
                if (image == null) continue;
                image.getImage().close();
            }
        }
    }

    private int getFrameByTime(long time) {
        long dr = 0L;
        for (int i = 0; i < this.frames.length; ++i) {
            if (dr <= time && dr + this.frames[i].delay > time) {
                return i;
            }
            dr += this.frames[i].delay;
        }
        return 0;
    }

    public static class ImageFrame {
        private final NativeImage image;
        private final long delay;

        public ImageFrame(NativeImage image, long delay) {
            this.image = image;
            this.delay = delay;
        }

        public long getDelay() {
            return this.delay;
        }

        public NativeImage getImage() {
            return this.image;
        }
    }
}

