/*
 * Decompiled with CFR 0.152.
 */
package red.felnull.otyacraftengine.client.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import red.felnull.otyacraftengine.client.util.IKSGTextureUtil;
import red.felnull.otyacraftengine.util.IKSGStringUtil;
import red.felnull.otyacraftengine.util.IKSGStyles;

@OnlyIn(value=Dist.CLIENT)
public class IKSGRenderUtil {
    private static final Map<ResourceLocation, IBakedModel> BAKED_MODELS = new HashMap<ResourceLocation, IBakedModel>();
    private static final Map<String, Integer> MISALIGNEDS = new HashMap<String, Integer>();
    private static final Map<String, Long> MISALIGNEDS_LASTTIMES = new HashMap<String, Long>();
    private static final Minecraft mc = Minecraft.func_71410_x();

    public static void drawPlayerFaseByUUID(MatrixStack matx, String uuid, int x, int y) {
        IKSGRenderUtil.matrixPush(matx);
        ResourceLocation plskin = IKSGTextureUtil.getPlayerSkinTextureByUUID(uuid);
        IKSGRenderUtil.guiBindAndBlit(plskin, matx, x, y, 8, 8, 8, 8, 64, 64);
        IKSGRenderUtil.guiBindAndBlit(plskin, matx, x, y, 40, 8, 8, 8, 64, 64);
        IKSGRenderUtil.matrixPop(matx);
    }

    public static void drawPlayerFase(MatrixStack matx, String name, int x, int y) {
        IKSGRenderUtil.matrixPush(matx);
        ResourceLocation plskin = IKSGTextureUtil.getPlayerSkinTexture(name);
        IKSGRenderUtil.guiBindAndBlit(plskin, matx, x, y, 8, 8, 8, 8, 64, 64);
        IKSGRenderUtil.guiBindAndBlit(plskin, matx, x, y, 40, 8, 8, 8, 64, 64);
        IKSGRenderUtil.matrixPop(matx);
    }

    public static void guiBindAndBlit(ResourceLocation location, MatrixStack matx, int x, int y, int textureStartX, int textureStartY, int textureFinishWidth, int textureFinishHeight) {
        IKSGRenderUtil.guiBindAndBlit(location, matx, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, 256);
    }

    public static void guiBindAndBlit(ResourceLocation location, MatrixStack matx, int x, int y, int textureStartX, int textureStartY, int textureFinishWidth, int textureFinishHeight, int textureSize) {
        IKSGRenderUtil.guiBindAndBlit(location, matx, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, textureSize, textureSize);
    }

    public static void guiBindAndBlit(ResourceLocation location, MatrixStack matx, int x, int y, int textureStartX, int textureStartY, int textureFinishWidth, int textureFinishHeight, int textureSizeX, int textureSizeY) {
        IKSGRenderUtil.matrixPush(matx);
        mc.func_110434_K().func_110577_a(location);
        IKSGRenderUtil.guiBlit(matx, x, y, textureStartX, textureStartY, textureFinishWidth, textureFinishHeight, textureSizeX, textureSizeY);
        IKSGRenderUtil.matrixPop(matx);
    }

    public static void guiBlit(MatrixStack matx, int x, int y, int textureStartX, int textureStartY, int textureFinishWidth, int textureFinishHeight, int textureSizeX, int textureSizeY) {
        AbstractGui.func_238463_a_((MatrixStack)matx, (int)x, (int)y, (float)textureStartX, (float)textureStartY, (int)textureFinishWidth, (int)textureFinishHeight, (int)textureSizeX, (int)textureSizeY);
    }

    public static void matrixTranslatef(MatrixStack ms, float x, float y, float z) {
        ms.func_227861_a_((double)x, (double)y, (double)z);
    }

    public static void matrixTranslatef16Divisions(MatrixStack ms, float x, float y, float z) {
        float pix = 0.0625f;
        IKSGRenderUtil.matrixTranslatef(ms, pix * x, pix * y, pix * z);
    }

    public static void matrixScalf(MatrixStack ms, float all) {
        IKSGRenderUtil.matrixScalf(ms, all, all, all);
    }

    public static void matrixScalf(MatrixStack ms, float x, float y, float z) {
        ms.func_227862_a_(x, y, z);
    }

    public static void matrixPush(MatrixStack ms) {
        ms.func_227860_a_();
    }

    public static void matrixPop(MatrixStack ms) {
        ms.func_227865_b_();
    }

    public static void matrixRotateDegreef(MatrixStack ms, float x, float y, float z) {
        IKSGRenderUtil.matrixRotateDegreefX(ms, x);
        IKSGRenderUtil.matrixRotateDegreefY(ms, y);
        IKSGRenderUtil.matrixRotateDegreefZ(ms, z);
    }

    public static void matrixRotateDegreefX(MatrixStack ms, float x) {
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(x));
    }

    public static void matrixRotateDegreefY(MatrixStack ms, float y) {
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(y));
    }

    public static void matrixRotateDegreefZ(MatrixStack ms, float z) {
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(z));
    }

    public static void matrixRotateHorizontal(BlockState state, MatrixStack matrix) {
        Direction direction = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
        IKSGRenderUtil.matrixRotateDirection(direction, matrix);
    }

    public static void matrixRotateDirection(Direction direction, MatrixStack matrix) {
        if (direction == Direction.WEST) {
            IKSGRenderUtil.matrixRotateDegreefY(matrix, 180.0f);
            IKSGRenderUtil.matrixTranslatef(matrix, -1.0f, 0.0f, -1.0f);
        } else if (direction == Direction.NORTH) {
            IKSGRenderUtil.matrixRotateDegreefY(matrix, 90.0f);
            IKSGRenderUtil.matrixTranslatef(matrix, -1.0f, 0.0f, 0.0f);
        } else if (direction == Direction.SOUTH) {
            IKSGRenderUtil.matrixRotateDegreefY(matrix, 270.0f);
            IKSGRenderUtil.matrixTranslatef(matrix, 0.0f, 0.0f, -1.0f);
        }
    }

    public static IBakedModel getBakedModel(ResourceLocation location) {
        if (BAKED_MODELS.containsKey(location)) {
            return BAKED_MODELS.get(location);
        }
        IBakedModel model = ModelLoader.instance().func_217845_a(location, (IModelTransform)ModelRotation.X0_Y0);
        BAKED_MODELS.put(location, model);
        return model;
    }

    public static void renderBlockBakedModel(IBakedModel modelIn, MatrixStack matrixIn, IVertexBuilder buffer, int combinedOverlayIn, TileEntity tile) {
        IKSGRenderUtil.renderBlockBakedModel((IBlockDisplayReader)tile.func_145831_w(), modelIn, tile.func_195044_w(), tile.func_174877_v(), matrixIn, buffer, tile.func_145831_w().field_73012_v, combinedOverlayIn);
    }

    public static void renderBlockBakedModel(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixIn, IVertexBuilder buffer, Random randomIn, int combinedOverlayIn) {
        IKSGRenderUtil.renderBlockBakedModel(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, false, randomIn, 0L, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    public static void renderBlockBakedModel(IBlockDisplayReader worldIn, IBakedModel modelIn, BlockState stateIn, BlockPos posIn, MatrixStack matrixIn, IVertexBuilder buffer, boolean checkSides, Random randomIn, long rand, int combinedOverlayIn, IModelData modelData) {
        BlockRendererDispatcher brd = mc.func_175602_ab();
        BlockModelRenderer bmr = brd.func_175019_b();
        bmr.renderModel(worldIn, modelIn, stateIn, posIn, matrixIn, buffer, checkSides, randomIn, rand, combinedOverlayIn, modelData);
    }

    public static void drawHorizontalMovementString(MatrixStack matrix, FontRenderer fontRenderer, String text, String id, int blank, int x, int y, int width, int speed, Style ... style) {
        int i;
        String intext;
        IFormattableTextComponent textc = IKSGStyles.withStyle((IFormattableTextComponent)new StringTextComponent(text), style);
        int textSize = fontRenderer.func_238414_a_((ITextProperties)textc);
        if (width >= textSize) {
            IKSGRenderUtil.drawString(fontRenderer, matrix, (ITextComponent)textc, x, y, 0);
            return;
        }
        int allsize = textSize + blank;
        if (!MISALIGNEDS.containsKey(id)) {
            MISALIGNEDS.put(id, 0);
            MISALIGNEDS_LASTTIMES.put(id, System.currentTimeMillis());
        } else {
            long conttime = System.currentTimeMillis() - MISALIGNEDS_LASTTIMES.get(id);
            if (conttime >= (long)(1000 / speed)) {
                int zures = MISALIGNEDS.get(id);
                if (zures >= allsize) {
                    MISALIGNEDS.put(id, 1);
                } else {
                    MISALIGNEDS.put(id, zures + 1);
                }
                MISALIGNEDS_LASTTIMES.put(id, System.currentTimeMillis());
            }
        }
        int zure = MISALIGNEDS.get(id);
        if (zure < textSize) {
            String cutble;
            int cuttoblesize;
            intext = text;
            for (i = 0; i < text.length() && textSize - zure <= (cuttoblesize = fontRenderer.func_238414_a_((ITextProperties)IKSGStyles.withStyle((IFormattableTextComponent)new StringTextComponent(cutble = IKSGStringUtil.cutForFront(text, i)), style))); ++i) {
                intext = cutble;
            }
            int backCont = 0;
            if (textSize - width > zure) {
                String cutble2;
                int cuttoblesize2;
                int tobidasizure = textSize - width > zure ? textSize - width - zure : 0;
                String aintext = text;
                for (int i2 = 0; i2 < text.length() && tobidasizure > (cuttoblesize2 = fontRenderer.func_238414_a_((ITextProperties)IKSGStyles.withStyle((IFormattableTextComponent)new StringTextComponent(cutble2 = IKSGStringUtil.cutForFront(text, text.length() - i2)), style))); ++i2) {
                    aintext = cutble2;
                }
                backCont = aintext.length();
            }
            int backContZure = fontRenderer.func_238414_a_((ITextProperties)IKSGStyles.withStyle((IFormattableTextComponent)new StringTextComponent(IKSGStringUtil.cutForFront(intext, intext.length() - backCont)), style));
            intext = IKSGStringUtil.cutForBack(intext, backCont);
            IFormattableTextComponent inextc = IKSGStyles.withStyle((IFormattableTextComponent)new StringTextComponent(intext), style);
            IKSGRenderUtil.drawBackString(fontRenderer, matrix, (ITextComponent)inextc, x + textSize - zure - backContZure, y, 0);
        }
        if (allsize - zure <= width) {
            String cutble;
            int cuttoblesize;
            intext = text;
            for (i = 0; i < text.length() && -(allsize - zure - width) <= (cuttoblesize = fontRenderer.func_238414_a_((ITextProperties)IKSGStyles.withStyle((IFormattableTextComponent)new StringTextComponent(cutble = IKSGStringUtil.cutForBack(text, i)), style))); ++i) {
                intext = cutble;
            }
            IFormattableTextComponent inextc = IKSGStyles.withStyle((IFormattableTextComponent)new StringTextComponent(intext), style);
            IKSGRenderUtil.drawString(fontRenderer, matrix, (ITextComponent)inextc, x + allsize - zure, y, 0);
        }
    }

    public static void drawStringShadowble(FontRenderer fr, MatrixStack matrix, ITextComponent text, int x, int y, int color) {
        fr.func_238407_a_(matrix, text.func_241878_f(), (float)x, (float)y, color);
    }

    public static void drawCenterStringShadowble(FontRenderer fr, MatrixStack matrix, ITextComponent text, int x, int y, int color) {
        int size = fr.func_238414_a_((ITextProperties)text);
        IKSGRenderUtil.drawStringShadowble(fr, matrix, text, x - size / 2, y, color);
    }

    public static void drawString(FontRenderer fr, MatrixStack matrix, ITextComponent text, int x, int y, int color) {
        fr.func_243248_b(matrix, text, (float)x, (float)y, color);
    }

    public static void drawCenterString(FontRenderer fr, MatrixStack matrix, ITextComponent text, int x, int y, int color) {
        int size = fr.func_238414_a_((ITextProperties)text);
        IKSGRenderUtil.drawString(fr, matrix, text, x - size / 2, y, color);
    }

    public static void drawString(FontRenderer fr, MatrixStack matrix, ITextComponent text, int x, int y, int color, boolean shadow) {
        if (shadow) {
            IKSGRenderUtil.drawStringShadowble(fr, matrix, text, x, y, color);
        } else {
            IKSGRenderUtil.drawString(fr, matrix, text, x, y, color);
        }
    }

    public static void drawCenterString(FontRenderer fr, MatrixStack matrix, ITextComponent text, int x, int y, int color, boolean shadow) {
        if (shadow) {
            IKSGRenderUtil.drawCenterStringShadowble(fr, matrix, text, x, y, color);
        } else {
            IKSGRenderUtil.drawCenterString(fr, matrix, text, x, y, color);
        }
    }

    public static void drawBackString(FontRenderer fr, MatrixStack matrix, ITextComponent text, int x, int y, int color) {
        int size = fr.func_238414_a_((ITextProperties)text);
        IKSGRenderUtil.drawString(fr, matrix, text, x - size, y, color);
    }

    public static void drawBackStringShadowble(FontRenderer fr, MatrixStack matrix, ITextComponent text, int x, int y, int color) {
        int size = fr.func_238414_a_((ITextProperties)text);
        IKSGRenderUtil.drawCenterStringShadowble(fr, matrix, text, x - size, y, color);
    }

    public static void drawBackString(FontRenderer fr, MatrixStack matrix, ITextComponent text, int x, int y, int color, boolean shadow) {
        if (shadow) {
            IKSGRenderUtil.drawBackStringShadowble(fr, matrix, text, x, y, color);
        } else {
            IKSGRenderUtil.drawBackString(fr, matrix, text, x, y, color);
        }
    }

    public static float partialTicksMisalignment(float val, float prevVal, float partialTicks) {
        return val + (prevVal - val) * partialTicks;
    }

    public static void renderSpritePanel(ResourceLocation texlocation, MatrixStack matrix, IRenderTypeBuffer bufferIn, float x, float y, float z, float pitch, float yaw, float roll, float w, float h, float texStartX, float texStartY, float texFinishX, float texFinishY, float texSizeW, float texSizeH, int combinedOverlayIn, int combinedLightIn) {
        IKSGRenderUtil.matrixPush(matrix);
        IKSGRenderUtil.matrixRotateDegreefY(matrix, yaw);
        IKSGRenderUtil.matrixRotateDegreefX(matrix, pitch);
        IKSGRenderUtil.matrixRotateDegreefZ(matrix, roll);
        IVertexBuilder ivb = bufferIn.getBuffer(IKSGRenderUtil.getTextuerRenderType(texlocation));
        float wst = texStartX / texSizeW;
        float wft = texFinishX / texSizeW + wst;
        float hst = texStartY / texSizeH;
        float hft = texFinishY / texSizeH + hst;
        IKSGRenderUtil.addVertex(ivb, matrix, x, y, z, wst, hft, combinedOverlayIn, combinedLightIn);
        IKSGRenderUtil.addVertex(ivb, matrix, w + x, y, z, wft, hft, combinedOverlayIn, combinedLightIn);
        IKSGRenderUtil.addVertex(ivb, matrix, w + x, h + y, z, wft, hst, combinedOverlayIn, combinedLightIn);
        IKSGRenderUtil.addVertex(ivb, matrix, x, h + y, z, wst, hst, combinedOverlayIn, combinedLightIn);
        IKSGRenderUtil.matrixPop(matrix);
    }

    public static void addVertex(IVertexBuilder builder, MatrixStack matrix, float x, float y, float z, float u, float v, int combinedOverlayIn, int combinedLightIn) {
        MatrixStack.Entry entry = matrix.func_227866_c_();
        builder.func_227888_a_(entry.func_227870_a_(), x, y, z).func_225586_a_(255, 255, 255, 255).func_225583_a_(u, v).func_227891_b_(combinedOverlayIn).func_227886_a_(combinedLightIn).func_227887_a_(entry.func_227872_b_(), 0.0f, 0.0f, 0.0f).func_181675_d();
    }

    public static RenderType getTextuerRenderType(ResourceLocation locationIn) {
        RenderType.State state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228726_a_(new RenderState.TransparencyState("no_transparency", RenderSystem::disableBlend, () -> {})).func_228716_a_(new RenderState.DiffuseLightingState(false)).func_228713_a_(new RenderState.AlphaState(0.003921569f)).func_228719_a_(new RenderState.LightmapState(true)).func_228722_a_(new RenderState.OverlayState(true)).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"entity_cutout", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)state);
    }

    public static void renderRightHand(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, AbstractClientPlayerEntity playerIn) {
        IKSGRenderUtil.matrixPush(matrixStack);
        mc.func_110434_K().func_110577_a(playerIn.func_110306_p());
        PlayerRenderer plr = (PlayerRenderer)mc.func_175598_ae().func_78713_a((Entity)playerIn);
        plr.func_229144_a_(matrixStack, bufferIn, combinedLightIn, playerIn);
        IKSGRenderUtil.matrixPop(matrixStack);
    }

    public static void renderLeftHand(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, AbstractClientPlayerEntity playerIn) {
        IKSGRenderUtil.matrixPush(matrixStack);
        mc.func_110434_K().func_110577_a(playerIn.func_110306_p());
        PlayerRenderer plr = (PlayerRenderer)mc.func_175598_ae().func_78713_a((Entity)playerIn);
        plr.func_229146_b_(matrixStack, bufferIn, combinedLightIn, playerIn);
        IKSGRenderUtil.matrixPop(matrixStack);
    }

    public static void matrixArmFirstPerson(MatrixStack matrixStackIn, float equippedProgress, float swingProgress, HandSide side) {
        boolean flag = side != HandSide.LEFT;
        float f = flag ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        IKSGRenderUtil.matrixTranslatef(matrixStackIn, f * (f2 + 0.64000005f), f3 + -0.6f + equippedProgress * -0.6f, f4 + -0.71999997f);
        IKSGRenderUtil.matrixRotateDegreefY(matrixStackIn, f * 45.0f);
        float f5 = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        IKSGRenderUtil.matrixRotateDegreefY(matrixStackIn, f * f6 * 70.0f);
        IKSGRenderUtil.matrixRotateDegreefZ(matrixStackIn, f * f5 * -20.0f);
        ClientPlayerEntity abstractclientplayerentity = IKSGRenderUtil.mc.field_71439_g;
        mc.func_110434_K().func_110577_a(abstractclientplayerentity.func_110306_p());
        IKSGRenderUtil.matrixTranslatef(matrixStackIn, f * -1.0f, 3.6f, 3.5f);
        IKSGRenderUtil.matrixRotateDegreefZ(matrixStackIn, f * 120.0f);
        IKSGRenderUtil.matrixRotateDegreefX(matrixStackIn, 200.0f);
        IKSGRenderUtil.matrixRotateDegreefY(matrixStackIn, f * -135.0f);
        IKSGRenderUtil.matrixTranslatef(matrixStackIn, f * 5.6f, 0.0f, 0.0f);
    }
}

